/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.excel;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.excel.ExcelReader;
import org.apache.nifi.excel.ExcelRecordReaderConfiguration;
import org.apache.nifi.excel.RowIterator;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.inference.RecordSource;
import org.apache.poi.ss.usermodel.Row;

public class ExcelRecordSource
implements RecordSource<Row> {
    private final RowIterator rowIterator;

    public ExcelRecordSource(InputStream in, PropertyContext context, Map<String, String> variables, ComponentLog logger) {
        String requiredSheetsDelimited = context.getProperty(ExcelReader.REQUIRED_SHEETS).evaluateAttributeExpressions(variables).getValue();
        List<String> requiredSheets = ExcelReader.getRequiredSheets(requiredSheetsDelimited);
        Integer rawFirstRow = context.getProperty(ExcelReader.STARTING_ROW).evaluateAttributeExpressions(variables).asInteger();
        int firstRow = rawFirstRow == null ? NumberUtils.toInt((String)ExcelReader.STARTING_ROW.getDefaultValue()) : rawFirstRow;
        int zeroBasedFirstRow = ExcelReader.getZeroBasedIndex(firstRow);
        String password = context.getProperty(ExcelReader.PASSWORD).getValue();
        ExcelRecordReaderConfiguration configuration = new ExcelRecordReaderConfiguration.Builder().withRequiredSheets(requiredSheets).withFirstRow(zeroBasedFirstRow).withPassword(password).build();
        this.rowIterator = new RowIterator(in, configuration, logger);
    }

    public Row next() {
        return this.rowIterator.hasNext() ? this.rowIterator.next() : null;
    }
}

