/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.pgp.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;

public class PGPOperationUtils {
    private static final boolean NESTED_SIGNATURE_DISABLED = false;
    private static final int BUFFER_SIZE = 2048;
    private static final long MODIFIED_MILLISECONDS = 86400000L;
    private static final Date MODIFIED = new Date(86400000L);
    private static final String FILE_NAME = String.class.getSimpleName();
    private static final char FILE_TYPE = 'b';

    public static byte[] getOnePassSignedData(byte[] contents, PGPPrivateKey privateKey) throws IOException, PGPException {
        PGPSignatureGenerator signatureGenerator = PGPOperationUtils.getSignatureGenerator(privateKey);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PGPOnePassSignature onePassSignature = signatureGenerator.generateOnePassVersion(false);
        onePassSignature.encode((OutputStream)outputStream);
        outputStream.write(contents);
        signatureGenerator.update(contents);
        PGPSignature signature = signatureGenerator.generate();
        signature.encode((OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    public static byte[] getOnePassSignedLiteralData(byte[] contents, PGPPrivateKey privateKey) throws IOException, PGPException {
        PGPSignatureGenerator signatureGenerator = PGPOperationUtils.getSignatureGenerator(privateKey);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PGPOnePassSignature onePassSignature = signatureGenerator.generateOnePassVersion(false);
        onePassSignature.encode((OutputStream)outputStream);
        PGPLiteralDataGenerator generator = new PGPLiteralDataGenerator();
        byte[] buffer = new byte[2048];
        try (OutputStream literalStream = generator.open((OutputStream)outputStream, 'b', FILE_NAME, MODIFIED, buffer);){
            literalStream.write(contents);
            signatureGenerator.update(contents);
        }
        PGPSignature signature = signatureGenerator.generate();
        signature.encode((OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    private static PGPSignatureGenerator getSignatureGenerator(PGPPrivateKey privateKey) throws PGPException {
        JcaPGPContentSignerBuilder contentSignerBuilder = new JcaPGPContentSignerBuilder(privateKey.getPublicKeyPacket().getAlgorithm(), 10);
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)contentSignerBuilder);
        signatureGenerator.init(0, privateKey);
        return signatureGenerator;
    }
}

