/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.pgp.service.standard;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.pgp.service.api.PGPPrivateKeyService;
import org.apache.nifi.pgp.service.standard.exception.PGPConfigurationException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.StringUtils;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPPrivateKey;
import org.bouncycastle.shaded.openpgp.PGPSecretKey;
import org.bouncycastle.shaded.openpgp.PGPSecretKeyRing;
import org.bouncycastle.shaded.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.shaded.openpgp.PGPUtil;
import org.bouncycastle.shaded.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.shaded.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

@Tags(value={"PGP", "GPG", "OpenPGP", "Encryption", "Private", "Key", "RFC 4880"})
@CapabilityDescription(value="PGP Private Key Service provides Private Keys loaded from files or properties")
public class StandardPGPPrivateKeyService
extends AbstractControllerService
implements PGPPrivateKeyService {
    public static final PropertyDescriptor KEYRING_FILE = new PropertyDescriptor.Builder().name("keyring-file").displayName("Keyring File").description("File path to PGP Keyring or Secret Key encoded in binary or ASCII Armor").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).build();
    public static final PropertyDescriptor KEYRING = new PropertyDescriptor.Builder().name("keyring").displayName("Keyring").description("PGP Keyring or Secret Key encoded in ASCII Armor").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor KEY_PASSWORD = new PropertyDescriptor.Builder().name("key-password").displayName("Key Password").description("Password used for decrypting Private Keys").required(true).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final Charset KEY_CHARSET = StandardCharsets.US_ASCII;
    private static final List<PropertyDescriptor> DESCRIPTORS = Arrays.asList(KEYRING_FILE, KEYRING, KEY_PASSWORD);
    private volatile Map<Long, PGPPrivateKey> privateKeys = Collections.emptyMap();

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        try {
            PBESecretKeyDecryptor keyDecryptor = this.getKeyDecryptor((PropertyContext)context);
            ArrayList<PGPPrivateKey> extractedPrivateKeys = new ArrayList<PGPPrivateKey>(this.readKeyringFile(keyDecryptor, (PropertyContext)context));
            extractedPrivateKeys.addAll(this.readKeyring(keyDecryptor, (PropertyContext)context));
            this.privateKeys = extractedPrivateKeys.stream().collect(Collectors.toMap(privateKey -> privateKey.getKeyID(), privateKey -> privateKey));
        }
        catch (RuntimeException e) {
            throw new InitializationException("Reading Private Keys Failed", (Throwable)e);
        }
    }

    @OnDisabled
    public void onDisabled() {
        this.privateKeys = Collections.emptyMap();
    }

    public Optional<PGPPrivateKey> findPrivateKey(long keyIdentifier) {
        this.getLogger().debug("Find Private Key [{}]", new Object[]{Long.toHexString(keyIdentifier).toUpperCase()});
        return Optional.ofNullable(this.privateKeys.get(keyIdentifier));
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ValidationResult result;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        PBESecretKeyDecryptor keyDecryptor = this.getKeyDecryptor((PropertyContext)context);
        ArrayList<PGPPrivateKey> extractedPrivateKeys = new ArrayList<PGPPrivateKey>();
        try {
            extractedPrivateKeys.addAll(this.readKeyringFile(keyDecryptor, (PropertyContext)context));
        }
        catch (RuntimeException e) {
            result = new ValidationResult.Builder().valid(false).subject(KEYRING_FILE.getDisplayName()).explanation(String.format("Reading Secret Keyring File Failed: %s", e.getMessage())).build();
            results.add(result);
        }
        try {
            extractedPrivateKeys.addAll(this.readKeyring(keyDecryptor, (PropertyContext)context));
        }
        catch (RuntimeException e) {
            result = new ValidationResult.Builder().valid(false).subject(KEYRING.getDisplayName()).explanation(String.format("Reading Secret Keyring Failed: %s", e.getMessage())).build();
            results.add(result);
        }
        if (extractedPrivateKeys.isEmpty()) {
            String explanation = String.format("No Private Keys Read from [%s] or [%s]", KEYRING_FILE.getDisplayName(), KEYRING.getDisplayName());
            result = new ValidationResult.Builder().valid(false).subject(((Object)((Object)this)).getClass().getSimpleName()).explanation(explanation).build();
            results.add(result);
        }
        return results;
    }

    private List<PGPPrivateKey> readKeyringFile(PBESecretKeyDecryptor keyDecryptor, PropertyContext context) {
        ArrayList<PGPPrivateKey> extractedPrivateKeys = new ArrayList<PGPPrivateKey>();
        String keyringFile = context.getProperty(KEYRING_FILE).evaluateAttributeExpressions().getValue();
        if (StringUtils.isNotBlank((String)keyringFile)) {
            try (FileInputStream inputStream = new FileInputStream(keyringFile);){
                extractedPrivateKeys.addAll(this.extractPrivateKeys(inputStream, keyDecryptor));
            }
            catch (IOException | RuntimeException e) {
                String message = String.format("Reading Secret Keyring File [%s] Failed", keyringFile);
                throw new PGPConfigurationException(message, e);
            }
        }
        return extractedPrivateKeys;
    }

    private List<PGPPrivateKey> readKeyring(PBESecretKeyDecryptor keyDecryptor, PropertyContext context) {
        ArrayList<PGPPrivateKey> extractedPrivateKeys = new ArrayList<PGPPrivateKey>();
        String keyring = context.getProperty(KEYRING).getValue();
        if (StringUtils.isNotBlank((String)keyring)) {
            byte[] keyringBytes = keyring.getBytes(KEY_CHARSET);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(keyringBytes);){
                extractedPrivateKeys.addAll(this.extractPrivateKeys(inputStream, keyDecryptor));
            }
            catch (IOException | RuntimeException e) {
                throw new PGPConfigurationException("Reading Secret Keyring Failed", e);
            }
        }
        return extractedPrivateKeys;
    }

    private List<PGPPrivateKey> extractPrivateKeys(InputStream inputStream, PBESecretKeyDecryptor keyDecryptor) {
        List<PGPPrivateKey> list;
        block8: {
            InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)inputStream);
            try {
                PGPSecretKeyRingCollection keyRings = this.readKeyRings(decoderStream);
                list = this.extractPrivateKeys(keyRings, keyDecryptor);
                if (decoderStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (decoderStream != null) {
                        try {
                            decoderStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PGPConfigurationException("Reading Secret Keyring Stream Failed", e);
                }
            }
            decoderStream.close();
        }
        return list;
    }

    private PGPSecretKeyRingCollection readKeyRings(InputStream inputStream) throws IOException {
        JcaKeyFingerprintCalculator calculator = new JcaKeyFingerprintCalculator();
        try {
            return new PGPSecretKeyRingCollection(inputStream, (KeyFingerPrintCalculator)calculator);
        }
        catch (PGPException e) {
            throw new PGPConfigurationException("Reading Secret Keyring Collection Failed", e);
        }
    }

    private List<PGPPrivateKey> extractPrivateKeys(PGPSecretKeyRingCollection keyRings, PBESecretKeyDecryptor keyDecryptor) {
        ArrayList<PGPPrivateKey> extractedPrivateKeys = new ArrayList<PGPPrivateKey>();
        for (PGPSecretKeyRing keyRing : keyRings) {
            for (PGPSecretKey secretKey : keyRing) {
                long keyId = secretKey.getKeyID();
                String keyIdentifier = Long.toHexString(keyId).toUpperCase();
                try {
                    PGPPrivateKey privateKey = secretKey.extractPrivateKey(keyDecryptor);
                    extractedPrivateKeys.add(privateKey);
                    this.getLogger().debug("Extracted Private Key [{}]", new Object[]{keyIdentifier});
                }
                catch (PGPException e) {
                    String message = String.format("Private Key [%s] Extraction Failed: check password", keyIdentifier);
                    throw new PGPConfigurationException(message, e);
                }
            }
        }
        return Collections.unmodifiableList(extractedPrivateKeys);
    }

    private PBESecretKeyDecryptor getKeyDecryptor(PropertyContext context) {
        String keyPassword = context.getProperty(KEY_PASSWORD).getValue();
        try {
            return new JcePBESecretKeyDecryptorBuilder().build(keyPassword.toCharArray());
        }
        catch (PGPException e) {
            throw new PGPConfigurationException("Building Secret Key Decryptor using password failed", e);
        }
    }
}

