/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.pgp.service.api.PGPPublicKeyService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.pgp.DecryptContentPGP;
import org.apache.nifi.processors.pgp.SignContentPGP;
import org.apache.nifi.processors.pgp.VerifyContentPGP;
import org.apache.nifi.processors.pgp.attributes.CompressionAlgorithm;
import org.apache.nifi.processors.pgp.attributes.FileEncoding;
import org.apache.nifi.processors.pgp.attributes.SymmetricKeyAlgorithm;
import org.apache.nifi.processors.pgp.exception.PGPEncryptionException;
import org.apache.nifi.processors.pgp.io.EncodingStreamCallback;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StringUtils;
import org.bouncycastle.shaded.bcpg.BCPGInputStream;
import org.bouncycastle.shaded.bcpg.Packet;
import org.bouncycastle.shaded.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPPublicKey;
import org.bouncycastle.shaded.openpgp.PGPUtil;
import org.bouncycastle.shaded.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.shaded.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.shaded.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.shaded.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"PGP", "GPG", "OpenPGP", "Encryption", "RFC 4880"})
@CapabilityDescription(value="Encrypt contents using OpenPGP. The processor reads input and detects OpenPGP messages to avoid unnecessary additional wrapping in Literal Data packets.")
@SeeAlso(value={DecryptContentPGP.class, SignContentPGP.class, VerifyContentPGP.class})
@WritesAttributes(value={@WritesAttribute(attribute="pgp.symmetric.key.algorithm", description="Symmetric-Key Algorithm"), @WritesAttribute(attribute="pgp.symmetric.key.algorithm.block.cipher", description="Symmetric-Key Algorithm Block Cipher"), @WritesAttribute(attribute="pgp.symmetric.key.algorithm.key.size", description="Symmetric-Key Algorithm Key Size"), @WritesAttribute(attribute="pgp.symmetric.key.algorithm.id", description="Symmetric-Key Algorithm Identifier"), @WritesAttribute(attribute="pgp.file.encoding", description="File Encoding"), @WritesAttribute(attribute="pgp.compression.algorithm", description="Compression Algorithm"), @WritesAttribute(attribute="pgp.compression.algorithm.id", description="Compression Algorithm Identifier")})
public class EncryptContentPGP
extends AbstractProcessor {
    public static final Relationship SUCCESS = new Relationship.Builder().name("success").description("Encryption Succeeded").build();
    public static final Relationship FAILURE = new Relationship.Builder().name("failure").description("Encryption Failed").build();
    public static final PropertyDescriptor SYMMETRIC_KEY_ALGORITHM = new PropertyDescriptor.Builder().name("symmetric-key-algorithm").displayName("Symmetric-Key Algorithm").description("Symmetric-Key Algorithm for encryption").required(true).defaultValue(SymmetricKeyAlgorithm.AES_256.toString()).allowableValues((Enum[])SymmetricKeyAlgorithm.values()).build();
    public static final PropertyDescriptor COMPRESSION_ALGORITHM = new PropertyDescriptor.Builder().name("compression-algorithm").displayName("Compression Algorithm").description("Compression Algorithm for encryption").required(true).defaultValue(CompressionAlgorithm.ZIP.toString()).allowableValues((Enum[])CompressionAlgorithm.values()).build();
    public static final PropertyDescriptor FILE_ENCODING = new PropertyDescriptor.Builder().name("file-encoding").displayName("File Encoding").description("File Encoding for encryption").required(true).defaultValue(FileEncoding.BINARY.toString()).allowableValues((Enum[])FileEncoding.values()).build();
    public static final PropertyDescriptor PASSPHRASE = new PropertyDescriptor.Builder().name("passphrase").displayName("Passphrase").description("Passphrase used for encrypting data with Password-Based Encryption").sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PUBLIC_KEY_SERVICE = new PropertyDescriptor.Builder().name("public-key-service").displayName("Public Key Service").description("PGP Public Key Service for encrypting data with Public Key Encryption").identifiesControllerService(PGPPublicKeyService.class).build();
    public static final PropertyDescriptor PUBLIC_KEY_SEARCH = new PropertyDescriptor.Builder().name("public-key-search").displayName("Public Key Search").description("PGP Public Key Search will be used to match against the User ID or Key ID when formatted as uppercase hexadecimal string of 16 characters").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).dependsOn(PUBLIC_KEY_SERVICE, new AllowableValue[0]).build();
    private static final boolean ENCRYPTION_INTEGRITY_PACKET_ENABLED = true;
    private static final Set<Relationship> RELATIONSHIPS = new HashSet<Relationship>(Arrays.asList(SUCCESS, FAILURE));
    private static final List<PropertyDescriptor> DESCRIPTORS = Arrays.asList(SYMMETRIC_KEY_ALGORITHM, COMPRESSION_ALGORITHM, FILE_ENCODING, PASSPHRASE, PUBLIC_KEY_SERVICE, PUBLIC_KEY_SEARCH);

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            PacketReadInputStreamCallback packetCallback = new PacketReadInputStreamCallback();
            session.read(flowFile, (InputStreamCallback)packetCallback);
            SymmetricKeyAlgorithm symmetricKeyAlgorithm = this.getSymmetricKeyAlgorithm(context);
            FileEncoding fileEncoding = this.getFileEncoding(context);
            CompressionAlgorithm compressionAlgorithm = this.getCompressionAlgorithm(context);
            StreamCallback callback = this.getEncryptStreamCallback(context, flowFile, symmetricKeyAlgorithm, compressionAlgorithm, fileEncoding, packetCallback.packetFound);
            flowFile = session.write(flowFile, callback);
            Map<String, String> attributes = this.getAttributes(symmetricKeyAlgorithm, fileEncoding, compressionAlgorithm);
            flowFile = session.putAllAttributes(flowFile, attributes);
            session.transfer(flowFile, SUCCESS);
        }
        catch (RuntimeException e) {
            this.getLogger().error("Encryption Failed {}", new Object[]{flowFile, e});
            session.transfer(flowFile, FAILURE);
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ValidationResult result;
        PGPPublicKeyService publicKeyService;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        String passphrase = context.getProperty(PASSPHRASE).getValue();
        if (StringUtils.isBlank((String)passphrase) && (publicKeyService = (PGPPublicKeyService)context.getProperty(PUBLIC_KEY_SERVICE).asControllerService(PGPPublicKeyService.class)) == null) {
            String explanation = String.format("Neither [%s] nor [%s] configured", PASSPHRASE.getDisplayName(), PUBLIC_KEY_SERVICE.getDisplayName());
            ValidationResult result2 = new ValidationResult.Builder().valid(false).subject(((Object)((Object)this)).getClass().getSimpleName()).explanation(explanation).build();
            results.add(result2);
        }
        if (context.getProperty(PUBLIC_KEY_SERVICE).isSet()) {
            result = new ValidationResult.Builder().valid(context.getProperty(PUBLIC_KEY_SEARCH).isSet()).subject(PUBLIC_KEY_SERVICE.getDisplayName()).explanation(String.format("[%s] requires [%s]", PUBLIC_KEY_SERVICE.getDisplayName(), PUBLIC_KEY_SEARCH.getDisplayName())).build();
            results.add(result);
        }
        if (context.getProperty(PUBLIC_KEY_SEARCH).isSet()) {
            result = new ValidationResult.Builder().valid(context.getProperty(PUBLIC_KEY_SERVICE).isSet()).subject(PUBLIC_KEY_SERVICE.getDisplayName()).explanation(String.format("[%s] requires [%s]", PUBLIC_KEY_SEARCH.getDisplayName(), PUBLIC_KEY_SERVICE.getDisplayName())).build();
            results.add(result);
        }
        return results;
    }

    private StreamCallback getEncryptStreamCallback(ProcessContext context, FlowFile flowFile, SymmetricKeyAlgorithm symmetricKeyAlgorithm, CompressionAlgorithm compressionAlgorithm, FileEncoding fileEncoding, boolean packetFound) {
        SecureRandom secureRandom = new SecureRandom();
        BcPGPDataEncryptorBuilder dataEncryptorBuilder = new BcPGPDataEncryptorBuilder(symmetricKeyAlgorithm.getId()).setSecureRandom(secureRandom).setWithIntegrityPacket(true);
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)dataEncryptorBuilder);
        List<PGPKeyEncryptionMethodGenerator> methodGenerators = this.getEncryptionMethodGenerators(context, flowFile, secureRandom);
        methodGenerators.forEach(arg_0 -> ((PGPEncryptedDataGenerator)encryptedDataGenerator).addMethod(arg_0));
        String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
        return new EncryptStreamCallback(fileEncoding, compressionAlgorithm, filename, packetFound, encryptedDataGenerator);
    }

    private List<PGPKeyEncryptionMethodGenerator> getEncryptionMethodGenerators(ProcessContext context, FlowFile flowFile, SecureRandom secureRandom) {
        String publicKeySearch;
        ArrayList<PGPKeyEncryptionMethodGenerator> generators = new ArrayList<PGPKeyEncryptionMethodGenerator>();
        PropertyValue passphraseProperty = context.getProperty(PASSPHRASE);
        if (passphraseProperty.isSet()) {
            char[] passphrase = passphraseProperty.getValue().toCharArray();
            generators.add((PGPKeyEncryptionMethodGenerator)new JcePBEKeyEncryptionMethodGenerator(passphrase).setSecureRandom(secureRandom));
        }
        if (StringUtils.isNotBlank((String)(publicKeySearch = context.getProperty(PUBLIC_KEY_SEARCH).evaluateAttributeExpressions(flowFile).getValue()))) {
            this.getLogger().debug("Public Key Search [{}]", new Object[]{publicKeySearch});
            PGPPublicKeyService publicKeyService = (PGPPublicKeyService)context.getProperty(PUBLIC_KEY_SERVICE).asControllerService(PGPPublicKeyService.class);
            Optional optionalPublicKey = publicKeyService.findPublicKey(publicKeySearch);
            if (optionalPublicKey.isPresent()) {
                PGPPublicKey publicKey = (PGPPublicKey)optionalPublicKey.get();
                generators.add((PGPKeyEncryptionMethodGenerator)new BcPublicKeyKeyEncryptionMethodGenerator(publicKey).setSecureRandom(secureRandom));
            } else {
                throw new PGPEncryptionException(String.format("Public Key not found using search [%s]", publicKeySearch));
            }
        }
        return generators;
    }

    private SymmetricKeyAlgorithm getSymmetricKeyAlgorithm(ProcessContext context) {
        String algorithm = context.getProperty(SYMMETRIC_KEY_ALGORITHM).getValue();
        return SymmetricKeyAlgorithm.valueOf(algorithm);
    }

    private CompressionAlgorithm getCompressionAlgorithm(ProcessContext context) {
        String algorithm = context.getProperty(COMPRESSION_ALGORITHM).getValue();
        return CompressionAlgorithm.valueOf(algorithm);
    }

    private FileEncoding getFileEncoding(ProcessContext context) {
        String encoding = context.getProperty(FILE_ENCODING).getValue();
        return FileEncoding.valueOf(encoding);
    }

    private Map<String, String> getAttributes(SymmetricKeyAlgorithm symmetricKeyAlgorithm, FileEncoding fileEncoding, CompressionAlgorithm compressionAlgorithm) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("pgp.symmetric.key.algorithm", symmetricKeyAlgorithm.toString());
        attributes.put("pgp.symmetric.key.algorithm.block.cipher", symmetricKeyAlgorithm.getBlockCipher().toString());
        attributes.put("pgp.symmetric.key.algorithm.key.size", Integer.toString(symmetricKeyAlgorithm.getKeySize()));
        attributes.put("pgp.symmetric.key.algorithm.id", Integer.toString(symmetricKeyAlgorithm.getId()));
        attributes.put("pgp.file.encoding", fileEncoding.toString());
        attributes.put("pgp.compression.algorithm", compressionAlgorithm.toString());
        attributes.put("pgp.compression.algorithm.id", Integer.toString(compressionAlgorithm.getId()));
        return attributes;
    }

    private static class EncryptStreamCallback
    extends EncodingStreamCallback {
        private final boolean packetFound;
        private final PGPEncryptedDataGenerator encryptedDataGenerator;

        public EncryptStreamCallback(FileEncoding fileEncoding, CompressionAlgorithm compressionAlgorithm, String filename, boolean packetFound, PGPEncryptedDataGenerator encryptedDataGenerator) {
            super(fileEncoding, compressionAlgorithm, filename);
            this.packetFound = packetFound;
            this.encryptedDataGenerator = encryptedDataGenerator;
        }

        @Override
        protected void processEncoding(InputStream inputStream, OutputStream encodingOutputStream) throws IOException, PGPException {
            try (OutputStream encryptedOutputStream = this.encryptedDataGenerator.open(encodingOutputStream, this.createOutputBuffer());){
                if (this.packetFound) {
                    StreamUtils.copy((InputStream)inputStream, (OutputStream)encryptedOutputStream);
                } else {
                    super.processEncoding(inputStream, encryptedOutputStream);
                }
            }
            this.encryptedDataGenerator.close();
        }
    }

    private class PacketReadInputStreamCallback
    implements InputStreamCallback {
        private boolean packetFound;

        private PacketReadInputStreamCallback() {
        }

        public void process(InputStream inputStream) {
            try {
                InputStream decodedInputStream = PGPUtil.getDecoderStream((InputStream)inputStream);
                BCPGInputStream packetInputStream = new BCPGInputStream(decodedInputStream);
                Packet packet = packetInputStream.readPacket();
                if (packet == null) {
                    EncryptContentPGP.this.getLogger().debug("PGP Packet not found");
                } else {
                    this.packetFound = true;
                }
            }
            catch (IOException e) {
                EncryptContentPGP.this.getLogger().debug("PGP Packet read failed", (Throwable)e);
            }
        }
    }
}

