/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.toc;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.provenance.toc.TocReader;
import org.apache.nifi.stream.io.StreamUtils;

public class StandardTocReader
implements TocReader {
    private final boolean compressed;
    private final long[] offsets;
    private final long[] firstEventIds;
    private final File file;

    public StandardTocReader(File file) throws IOException {
        this.file = file;
        long fileLength = file.length();
        if (fileLength < 2L) {
            if (file.exists()) {
                throw new EOFException();
            }
            throw new FileNotFoundException();
        }
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] buffer = new byte[(int)fileLength];
            StreamUtils.fillBuffer((InputStream)fis, (byte[])buffer);
            byte version = buffer[0];
            byte compressionFlag = buffer[1];
            if (compressionFlag == 0) {
                this.compressed = false;
            } else if (compressionFlag == 1) {
                this.compressed = true;
            } else {
                throw new IOException("Table of Contents file " + file + " appears to be corrupt: could not read 'compression flag' from header; expected value of 0 or 1 but got " + compressionFlag);
            }
            int numBlocks = (buffer.length - 2) / (switch (version) {
                case 1 -> 8;
                default -> 16;
            });
            this.offsets = new long[numBlocks];
            this.firstEventIds = version > 1 ? new long[numBlocks] : new long[0];
            int index = 2;
            for (int i = 0; i < numBlocks; ++i) {
                this.offsets[i] = this.readLong(buffer, index);
                index += 8;
                if (version <= 1) continue;
                this.firstEventIds[i] = this.readLong(buffer, index);
                index += 8;
            }
        }
    }

    private long readLong(byte[] buffer, int offset) {
        return ((long)buffer[offset] << 56) + ((long)(buffer[offset + 1] & 0xFF) << 48) + ((long)(buffer[offset + 2] & 0xFF) << 40) + ((long)(buffer[offset + 3] & 0xFF) << 32) + ((long)(buffer[offset + 4] & 0xFF) << 24) + ((long)(buffer[offset + 5] & 0xFF) << 16) + ((long)(buffer[offset + 6] & 0xFF) << 8) + (long)(buffer[offset + 7] & 0xFF);
    }

    @Override
    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getBlockOffset(int blockIndex) {
        if (blockIndex >= this.offsets.length) {
            return -1L;
        }
        return this.offsets[blockIndex];
    }

    @Override
    public long getFirstEventIdForBlock(int blockIndex) {
        if (blockIndex >= this.firstEventIds.length) {
            return -1L;
        }
        return this.firstEventIds[blockIndex];
    }

    @Override
    public long getLastBlockOffset() {
        if (this.offsets.length == 0) {
            return 0L;
        }
        return this.offsets[this.offsets.length - 1];
    }

    @Override
    public void close() {
    }

    @Override
    public int getBlockIndex(long blockOffset) {
        for (int i = 0; i < this.offsets.length; ++i) {
            if (this.offsets[i] <= blockOffset) continue;
            return i == 0 ? 0 : i - 1;
        }
        return this.offsets.length - 1;
    }

    @Override
    public Integer getBlockIndexForEventId(long eventId) {
        if (this.firstEventIds.length == 0 || eventId < this.firstEventIds[0]) {
            return null;
        }
        for (int i = 1; i < this.firstEventIds.length; ++i) {
            if (this.firstEventIds[i] <= eventId) continue;
            return i - 1;
        }
        return this.firstEventIds.length - 1;
    }

    public String toString() {
        return "StandardTocReader[file=" + this.file + ", compressed=" + this.compressed + "]";
    }
}

