/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.index.lucene;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.document.Document;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.index.EventIndexWriter;
import org.apache.nifi.provenance.index.lucene.ConvertEventToLuceneDocument;
import org.apache.nifi.provenance.index.lucene.IndexDirectoryManager;
import org.apache.nifi.provenance.lucene.IndexManager;
import org.apache.nifi.provenance.store.EventStore;
import org.apache.nifi.provenance.store.iterator.EventIterator;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateDefunctIndex
implements Runnable {
    private static final String TEMP_FILENAME_PREFIX = "temp-lucene-8-";
    private static final String MIGRATED_FILENAME_PREFIX = "lucene-8-";
    private static final Logger logger = LoggerFactory.getLogger(MigrateDefunctIndex.class);
    private final File indexDirectory;
    private final IndexManager indexManager;
    private final IndexDirectoryManager directoryManager;
    private final EventStore eventStore;
    private final EventReporter eventReporter;
    private final ConvertEventToLuceneDocument eventConverter;
    private final long minTimestamp;
    private final long maxTimestamp;
    private final AtomicInteger rebuildCount;
    private final int totalCount;
    private long successCount = 0L;

    public MigrateDefunctIndex(File indexDirectory, IndexManager indexManager, IndexDirectoryManager directoryManager, long minTimestamp, long maxTimestamp, EventStore eventStore, EventReporter eventReporter, ConvertEventToLuceneDocument eventConverter, AtomicInteger rebuildCount, int totalCount) {
        this.indexDirectory = indexDirectory;
        this.indexManager = indexManager;
        this.directoryManager = directoryManager;
        this.eventStore = eventStore;
        this.eventReporter = eventReporter;
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.eventConverter = eventConverter;
        this.rebuildCount = rebuildCount;
        this.totalCount = totalCount;
    }

    @Override
    public void run() {
        File migratedIndexDir;
        File tempIndexDir = new File(this.indexDirectory.getParentFile(), TEMP_FILENAME_PREFIX + this.indexDirectory.getName());
        boolean preconditionsMet = this.verifyPreconditions(tempIndexDir, migratedIndexDir = new File(this.indexDirectory.getParentFile(), MIGRATED_FILENAME_PREFIX + this.indexDirectory.getName()));
        if (!preconditionsMet) {
            this.rebuildCount.incrementAndGet();
            return;
        }
        try {
            this.rebuildIndex(tempIndexDir, migratedIndexDir);
            this.directoryManager.replaceDirectory(this.indexDirectory, migratedIndexDir, true);
            logger.info("Successfully rebuilt Lucene Index {} as {}; {} of {} indices remain to be rebuilt", new Object[]{this.indexDirectory, migratedIndexDir, this.totalCount - this.rebuildCount.incrementAndGet(), this.totalCount});
        }
        catch (Exception e) {
            logger.error("Failed to migrate event index {} to {} after successfully re-indexing {} events", new Object[]{this.indexDirectory, tempIndexDir, this.successCount, e});
            this.eventReporter.reportEvent(Severity.ERROR, "Provenance Event Index Migration", "Failed to  migrate event index " + this.indexDirectory + " - see logs for more details.");
            this.rebuildCount.incrementAndGet();
        }
    }

    private boolean verifyPreconditions(File tempIndexDir, File migratedIndexDir) {
        if (tempIndexDir.exists()) {
            try {
                FileUtils.deleteFile((File)tempIndexDir, (boolean)true);
            }
            catch (Exception e) {
                logger.error("Attempted to rebuild index for {} but there already exists a temporary Lucene 8 index at {}. Attempted to delete existing temp directory but failed. This index will not be rebuilt.", (Object)tempIndexDir, (Object)e);
                return false;
            }
        }
        if (migratedIndexDir.exists()) {
            try {
                FileUtils.deleteFile((File)migratedIndexDir, (boolean)true);
            }
            catch (Exception e) {
                logger.error("Attempted to rebuild index for {} but there already exists a Lucene 8 index at {}. Attempted to delete existing Lucene 8 directory but failed. This index will not be rebuilt.", (Object)migratedIndexDir, (Object)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildIndex(File tempIndexDir, File migratedIndexDir) throws IOException {
        EventIndexWriter writer = this.indexManager.borrowIndexWriter(tempIndexDir);
        try {
            Optional<ProvenanceEventRecord> optionalEvent;
            EventIterator eventIterator = this.eventStore.getEventsByTimestamp(this.minTimestamp, this.maxTimestamp);
            StopWatch stopWatch = new StopWatch(true);
            while ((optionalEvent = eventIterator.nextEvent()).isPresent()) {
                ProvenanceEventRecord event = optionalEvent.get();
                Document document = this.eventConverter.convert(event, event.getEventId());
                writer.index(document, Integer.MAX_VALUE);
                ++this.successCount;
            }
            writer.commit();
            stopWatch.stop();
            logger.info("Successfully indexed {} events to {} in {}", new Object[]{this.successCount, tempIndexDir, stopWatch.getDuration()});
        }
        finally {
            this.indexManager.returnIndexWriter(writer, true, true);
        }
        Files.move(tempIndexDir.toPath(), migratedIndexDir.toPath(), new CopyOption[0]);
    }
}

