/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.serialization.CompressableRecordWriter;
import org.apache.nifi.provenance.serialization.RecordWriter;
import org.apache.nifi.provenance.toc.TocWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class StandardRecordWriter
extends CompressableRecordWriter
implements RecordWriter {
    public static final int MAX_ALLOWED_UTF_LENGTH = 65535;
    private static final Logger logger = LoggerFactory.getLogger(StandardRecordWriter.class);
    public static final int SERIALIZATION_VERISON = 9;
    public static final String SERIALIZATION_NAME = "org.apache.nifi.provenance.PersistentProvenanceRepository";
    private final File file;

    public StandardRecordWriter(File file, AtomicLong idGenerator, TocWriter writer, boolean compressed, int uncompressedBlockSize) throws IOException {
        super(file, idGenerator, writer, compressed, uncompressedBlockSize);
        logger.trace("Creating Record Writer for {}", (Object)file.getName());
        this.file = file;
    }

    public StandardRecordWriter(OutputStream out, String storageLocation, AtomicLong idGenerator, TocWriter tocWriter, boolean compressed, int uncompressedBlockSize) throws IOException {
        super(out, storageLocation, idGenerator, tocWriter, compressed, uncompressedBlockSize);
        this.file = null;
    }

    @Override
    protected String getSerializationName() {
        return SERIALIZATION_NAME;
    }

    @Override
    protected int getSerializationVersion() {
        return 9;
    }

    @Override
    protected void writeHeader(long firstEventId, DataOutputStream out) throws IOException {
    }

    @Override
    protected void writeRecord(ProvenanceEventRecord record, long recordIdentifier, DataOutputStream out) throws IOException {
        ProvenanceEventType recordType = record.getEventType();
        out.writeLong(recordIdentifier);
        this.writeUTFLimited(out, record.getEventType().name(), "EventType");
        out.writeLong(record.getEventTime());
        out.writeLong(record.getFlowFileEntryDate());
        out.writeLong(record.getEventDuration());
        out.writeLong(record.getLineageStartDate());
        this.writeNullableString(out, record.getComponentId(), "ComponentId");
        this.writeNullableString(out, record.getComponentType(), "ComponentType");
        this.writeUUID(out, record.getFlowFileUuid());
        this.writeNullableString(out, record.getDetails(), "Details");
        Map attrs = record.getPreviousAttributes();
        out.writeInt(attrs.size());
        for (Map.Entry entry : attrs.entrySet()) {
            this.writeLongString(out, (String)entry.getKey());
            this.writeLongString(out, (String)entry.getValue());
        }
        Map attrUpdates = record.getUpdatedAttributes();
        out.writeInt(attrUpdates.size());
        for (Map.Entry entry : attrUpdates.entrySet()) {
            this.writeLongString(out, (String)entry.getKey());
            this.writeLongNullableString(out, (String)entry.getValue());
        }
        if (record.getContentClaimSection() != null && record.getContentClaimContainer() != null && record.getContentClaimIdentifier() != null) {
            out.writeBoolean(true);
            this.writeUTFLimited(out, record.getContentClaimContainer(), "ContentClaimContainer");
            this.writeUTFLimited(out, record.getContentClaimSection(), "ContentClaimSection");
            this.writeUTFLimited(out, record.getContentClaimIdentifier(), "ContentClaimIdentifier");
            if (record.getContentClaimOffset() == null) {
                out.writeLong(0L);
            } else {
                out.writeLong(record.getContentClaimOffset());
            }
            out.writeLong(record.getFileSize());
        } else {
            out.writeBoolean(false);
        }
        if (record.getPreviousContentClaimSection() != null && record.getPreviousContentClaimContainer() != null && record.getPreviousContentClaimIdentifier() != null) {
            out.writeBoolean(true);
            this.writeUTFLimited(out, record.getPreviousContentClaimContainer(), "PreviousContentClaimContainer");
            this.writeUTFLimited(out, record.getPreviousContentClaimSection(), "PreviousContentClaimSection");
            this.writeUTFLimited(out, record.getPreviousContentClaimIdentifier(), "PreviousContentClaimIdentifier");
            if (record.getPreviousContentClaimOffset() == null) {
                out.writeLong(0L);
            } else {
                out.writeLong(record.getPreviousContentClaimOffset());
            }
            if (record.getPreviousFileSize() == null) {
                out.writeLong(0L);
            } else {
                out.writeLong(record.getPreviousFileSize());
            }
        } else {
            out.writeBoolean(false);
        }
        this.writeNullableString(out, record.getSourceQueueIdentifier(), "SourceQueueIdentifier");
        if (recordType == ProvenanceEventType.FORK || recordType == ProvenanceEventType.JOIN || recordType == ProvenanceEventType.CLONE || recordType == ProvenanceEventType.REPLAY) {
            this.writeUUIDs(out, record.getParentUuids());
            this.writeUUIDs(out, record.getChildUuids());
        } else if (recordType == ProvenanceEventType.RECEIVE) {
            this.writeNullableString(out, record.getTransitUri(), "TransitUri");
            this.writeNullableString(out, record.getSourceSystemFlowFileIdentifier(), "SourceSystemFlowFileIdentifier");
        } else if (recordType == ProvenanceEventType.FETCH) {
            this.writeNullableString(out, record.getTransitUri(), "TransitUri");
        } else if (recordType == ProvenanceEventType.SEND) {
            this.writeNullableString(out, record.getTransitUri(), "TransitUri");
        } else if (recordType == ProvenanceEventType.ADDINFO) {
            this.writeNullableString(out, record.getAlternateIdentifierUri(), "AlternateIdentifierUri");
        } else if (recordType == ProvenanceEventType.ROUTE) {
            this.writeNullableString(out, record.getRelationship(), "Relationship");
        }
    }

    protected void writeUUID(DataOutputStream out, String uuid) throws IOException {
        this.writeUTFLimited(out, uuid, "UUID");
    }

    protected void writeUUIDs(DataOutputStream out, Collection<String> list) throws IOException {
        if (list == null) {
            out.writeInt(0);
        } else {
            out.writeInt(list.size());
            for (String value : list) {
                this.writeUUID(out, value);
            }
        }
    }

    protected void writeNullableString(DataOutputStream out, String toWrite, String fieldName) throws IOException {
        if (toWrite == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.writeUTFLimited(out, toWrite, fieldName);
        }
    }

    private void writeLongNullableString(DataOutputStream out, String toWrite) throws IOException {
        if (toWrite == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.writeLongString(out, toWrite);
        }
    }

    private void writeLongString(DataOutputStream out, String value) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    private void writeUTFLimited(DataOutputStream out, String utfString, String fieldName) throws IOException {
        try {
            out.writeUTF(utfString);
        }
        catch (UTFDataFormatException e) {
            String truncated = utfString.substring(0, StandardRecordWriter.getCharsInUTF8Limit(utfString, 65535));
            logger.warn("Truncating repository record value for field '{}'!  Attempted to write {} chars that encode to a UTF8 byte length greater than supported maximum ({}), truncating to {} chars.", new Object[]{fieldName == null ? "" : fieldName, utfString.length(), 65535, truncated.length()});
            if (logger.isDebugEnabled()) {
                logger.warn("String value was:\n{}", (Object)truncated);
            }
            out.writeUTF(truncated);
        }
    }

    static int getCharsInUTF8Limit(String str, int utf8Limit) {
        int charsInOriginal = str.length();
        int bytesInUTF8 = 0;
        for (int i = 0; i < charsInOriginal; ++i) {
            char curr = str.charAt(i);
            bytesInUTF8 = curr < '\u0080' ? ++bytesInUTF8 : (curr < '\u0800' ? (bytesInUTF8 += 2) : (bytesInUTF8 += 3));
            if (bytesInUTF8 <= utf8Limit) continue;
            return i;
        }
        return charsInOriginal;
    }

    public String toString() {
        return "StandardRecordWriter[file=" + this.file + "]";
    }
}

