/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.store.iterator;

import java.io.IOException;
import java.util.Optional;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.authorization.EventAuthorizer;
import org.apache.nifi.provenance.authorization.EventTransformer;
import org.apache.nifi.provenance.store.iterator.EventIterator;

public class AuthorizingEventIterator
implements EventIterator {
    private final EventIterator iterator;
    private final EventAuthorizer authorizer;
    private final EventTransformer transformer;

    public AuthorizingEventIterator(EventIterator iterator, EventAuthorizer authorizer, EventTransformer unauthorizedTransformer) {
        this.iterator = iterator;
        this.authorizer = authorizer;
        this.transformer = unauthorizedTransformer;
    }

    @Override
    public void close() throws IOException {
        this.iterator.close();
    }

    @Override
    public Optional<ProvenanceEventRecord> nextEvent() throws IOException {
        Optional<ProvenanceEventRecord> next;
        Optional<ProvenanceEventRecord> eventOption;
        do {
            if (!(next = this.iterator.nextEvent()).isPresent()) {
                return next;
            }
            if (!this.authorizer.isAuthorized(next.get())) continue;
            return next;
        } while (!(eventOption = this.transformer.transform(next.get())).isPresent());
        return eventOption;
    }
}

