/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.expiration;

import java.io.File;
import java.io.IOException;
import org.apache.nifi.provenance.expiration.ExpirationAction;
import org.apache.nifi.provenance.toc.TocUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRemovalAction
implements ExpirationAction {
    private static final Logger logger = LoggerFactory.getLogger(FileRemovalAction.class);

    @Override
    public File execute(File expiredFile) throws IOException {
        boolean removed = this.remove(expiredFile);
        if (removed) {
            logger.info("Removed expired Provenance Event file {}", (Object)expiredFile);
        } else {
            logger.warn("Failed to remove old Provenance Event file {}; this file should be cleaned up manually", (Object)expiredFile);
        }
        File tocFile = TocUtil.getTocFile(expiredFile);
        if (this.remove(tocFile)) {
            logger.info("Removed expired Provenance Table-of-Contents file {}", (Object)tocFile);
        } else {
            logger.warn("Failed to remove old Provenance Table-of-Contents file {}; this file should be cleaned up manually", (Object)expiredFile);
        }
        return removed ? null : expiredFile;
    }

    private boolean remove(File file) {
        boolean removed = false;
        for (int i = 0; i < 10 && !removed; ++i) {
            removed = file.delete();
            if (!removed) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBeenPerformed(File expiredFile) throws IOException {
        return !expiredFile.exists();
    }
}

