/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.authorization;

import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.provenance.ProvenanceAuthorizableFactory;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.authorization.EventAuthorizer;
import org.apache.nifi.web.ResourceNotFoundException;

public class UserEventAuthorizer
implements EventAuthorizer {
    private final Authorizer authorizer;
    private final ProvenanceAuthorizableFactory resourceFactory;
    private final NiFiUser user;

    public UserEventAuthorizer(Authorizer authorizer, ProvenanceAuthorizableFactory authorizableFactory, NiFiUser user) {
        this.authorizer = authorizer;
        this.resourceFactory = authorizableFactory;
        this.user = user;
    }

    @Override
    public boolean isAuthorized(ProvenanceEventRecord event) {
        Authorizable eventAuthorizable;
        if (this.authorizer == null || this.user == null) {
            return true;
        }
        try {
            eventAuthorizable = this.resourceFactory.createProvenanceDataAuthorizable(event.getComponentId());
        }
        catch (ResourceNotFoundException rnfe) {
            return false;
        }
        AuthorizationResult result = eventAuthorizable.checkAuthorization(this.authorizer, RequestAction.READ, this.user);
        return AuthorizationResult.Result.Approved.equals((Object)result.getResult());
    }

    @Override
    public void authorize(ProvenanceEventRecord event) {
        if (this.authorizer == null) {
            return;
        }
        Authorizable eventAuthorizable = this.resourceFactory.createProvenanceDataAuthorizable(event.getComponentId());
        eventAuthorizable.authorize(this.authorizer, RequestAction.READ, this.user);
    }
}

