/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.store;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.apache.nifi.provenance.lucene.LuceneUtil;
import org.apache.nifi.util.Tuple;

public class EventFileManager {
    private final ConcurrentMap<String, Tuple<ReadWriteLock, Integer>> lockMap = new ConcurrentHashMap<String, Tuple<ReadWriteLock, Integer>>();

    private String getMapKey(File file) {
        return LuceneUtil.substringBefore(file.getName(), ".prov");
    }

    private ReadWriteLock updateCount(File file, Function<Integer, Integer> update) {
        String key = this.getMapKey(file);
        boolean updated = false;
        Tuple updatedTuple = null;
        while (!updated) {
            Tuple tuple = this.lockMap.computeIfAbsent(key, k -> new Tuple((Object)new ReentrantReadWriteLock(), (Object)0));
            Integer updatedCount = update.apply((Integer)tuple.getValue());
            updatedTuple = new Tuple((Object)((ReadWriteLock)tuple.getKey()), (Object)updatedCount);
            updated = this.lockMap.replace(key, (Tuple<ReadWriteLock, Integer>)tuple, (Tuple<ReadWriteLock, Integer>)updatedTuple);
        }
        return (ReadWriteLock)updatedTuple.getKey();
    }

    private ReadWriteLock incrementCount(File file) {
        return this.updateCount(file, val -> val + 1);
    }

    private ReadWriteLock decrementCount(File file) {
        return this.updateCount(file, val -> val - 1);
    }

    public void obtainReadLock(File file) {
        ReadWriteLock rwLock = this.incrementCount(file);
        rwLock.readLock().lock();
    }

    public void releaseReadLock(File file) {
        ReadWriteLock rwLock = this.decrementCount(file);
        rwLock.readLock().unlock();
    }

    public void obtainWriteLock(File file) {
        ReadWriteLock rwLock = this.incrementCount(file);
        rwLock.writeLock().lock();
    }

    public void releaseWriteLock(File file) {
        String key = this.getMapKey(file);
        boolean updated = false;
        while (!updated) {
            Tuple tuple = (Tuple)this.lockMap.get(key);
            if (tuple == null) {
                throw new IllegalMonitorStateException("Lock is not owned");
            }
            if ((Integer)tuple.getValue() <= 1) {
                updated = this.lockMap.remove(key, tuple);
                if (!updated) continue;
                ((ReadWriteLock)tuple.getKey()).writeLock().unlock();
                continue;
            }
            Tuple updatedTuple = new Tuple((Object)((ReadWriteLock)tuple.getKey()), (Object)((Integer)tuple.getValue() - 1));
            updated = this.lockMap.replace(key, (Tuple<ReadWriteLock, Integer>)tuple, (Tuple<ReadWriteLock, Integer>)updatedTuple);
            if (!updated) continue;
            ((ReadWriteLock)tuple.getKey()).writeLock().unlock();
        }
    }
}

