/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
    private final String namePrefix;
    private final boolean daemon;

    public NamedThreadFactory(String namePrefix) {
        this(namePrefix, false);
    }

    public NamedThreadFactory(String namePrefix, boolean daemon) {
        this.namePrefix = namePrefix;
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = this.defaultThreadFactory.newThread(r);
        thread.setName(this.namePrefix + "-" + this.counter.incrementAndGet());
        thread.setDaemon(this.daemon);
        return thread;
    }
}

