/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.index.lucene;

import java.util.List;
import java.util.Optional;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.index.lucene.CachedQuery;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.serialization.StorageSummary;
import org.apache.nifi.util.RingBuffer;

public class LatestEventsQuery
implements CachedQuery {
    final RingBuffer<Long> latestRecords = new RingBuffer(1000);

    @Override
    public void update(ProvenanceEventRecord event, StorageSummary storageSummary) {
        this.latestRecords.add((Object)storageSummary.getEventId());
    }

    @Override
    public Optional<List<Long>> evaluate(Query query) {
        if (this.latestRecords.getSize() < query.getMaxResults()) {
            return Optional.empty();
        }
        if (query.getSearchTerms().isEmpty() && query.getStartDate() == null && query.getEndDate() == null) {
            List eventList = this.latestRecords.asList();
            if (eventList.size() > query.getMaxResults()) {
                return Optional.of(eventList.subList(0, query.getMaxResults()));
            }
            return Optional.of(eventList);
        }
        return Optional.empty();
    }

    public String toString() {
        return "Most Recent Events Query";
    }
}

