/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.index.lucene;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.SearchableFields;
import org.apache.nifi.provenance.lucene.LuceneUtil;
import org.apache.nifi.provenance.search.SearchableField;
import org.apache.nifi.provenance.serialization.StorageSummary;

public class ConvertEventToLuceneDocument {
    private final Set<SearchableField> searchableEventFields;
    private final Set<SearchableField> searchableAttributeFields;

    public ConvertEventToLuceneDocument(List<SearchableField> searchableEventFields, List<SearchableField> searchableAttributes) {
        this.searchableEventFields = Collections.unmodifiableSet(new HashSet<SearchableField>(searchableEventFields));
        this.searchableAttributeFields = Collections.unmodifiableSet(new HashSet<SearchableField>(searchableAttributes));
    }

    private void addField(Document doc, SearchableField field, String value) {
        if (value == null || !field.isAttribute() && !this.searchableEventFields.contains(field)) {
            return;
        }
        doc.add((IndexableField)new StringField(field.getSearchableFieldName(), value.toLowerCase(), Field.Store.NO));
    }

    public Document convert(ProvenanceEventRecord record, StorageSummary persistedEvent) {
        return this.convert(record, persistedEvent.getEventId());
    }

    public Document convert(ProvenanceEventRecord record, long eventId) {
        String string;
        int lastColon;
        String sourceFlowFileUUID;
        Document doc = new Document();
        this.addField(doc, SearchableFields.FlowFileUUID, record.getFlowFileUuid());
        this.addField(doc, SearchableFields.Filename, record.getAttribute(CoreAttributes.FILENAME.key()));
        this.addField(doc, SearchableFields.ComponentID, record.getComponentId());
        this.addField(doc, SearchableFields.AlternateIdentifierURI, record.getAlternateIdentifierUri());
        this.addField(doc, SearchableFields.EventType, record.getEventType().name());
        this.addField(doc, SearchableFields.Relationship, record.getRelationship());
        this.addField(doc, SearchableFields.Details, record.getDetails());
        this.addField(doc, SearchableFields.ContentClaimSection, record.getContentClaimSection());
        this.addField(doc, SearchableFields.ContentClaimContainer, record.getContentClaimContainer());
        this.addField(doc, SearchableFields.ContentClaimIdentifier, record.getContentClaimIdentifier());
        this.addField(doc, SearchableFields.SourceQueueIdentifier, record.getSourceQueueIdentifier());
        this.addField(doc, SearchableFields.TransitURI, record.getTransitUri());
        for (SearchableField searchableField : this.searchableAttributeFields) {
            this.addField(doc, searchableField, LuceneUtil.truncateIndexField(record.getAttribute(searchableField.getSearchableFieldName())));
        }
        if (doc.getFields().isEmpty()) {
            return null;
        }
        doc.add((IndexableField)new LongPoint(SearchableFields.LineageStartDate.getSearchableFieldName(), new long[]{record.getLineageStartDate()}));
        doc.add((IndexableField)new LongPoint(SearchableFields.EventTime.getSearchableFieldName(), new long[]{record.getEventTime()}));
        doc.add((IndexableField)new LongPoint(SearchableFields.FileSize.getSearchableFieldName(), new long[]{record.getFileSize()}));
        doc.add((IndexableField)new UnIndexedLongField(SearchableFields.Identifier.getSearchableFieldName(), eventId));
        ProvenanceEventType eventType = record.getEventType();
        if (eventType == ProvenanceEventType.FORK || eventType == ProvenanceEventType.CLONE || eventType == ProvenanceEventType.REPLAY) {
            for (String uuid : record.getChildUuids()) {
                if (uuid.equals(record.getFlowFileUuid())) continue;
                this.addField(doc, SearchableFields.FlowFileUUID, uuid);
            }
        } else if (eventType == ProvenanceEventType.JOIN) {
            for (String uuid : record.getParentUuids()) {
                if (uuid.equals(record.getFlowFileUuid())) continue;
                this.addField(doc, SearchableFields.FlowFileUUID, uuid);
            }
        } else if (eventType == ProvenanceEventType.RECEIVE && record.getSourceSystemFlowFileIdentifier() != null && (sourceFlowFileUUID = (lastColon = (string = record.getSourceSystemFlowFileIdentifier()).lastIndexOf(":")) > -1 && lastColon < string.length() - 2 ? string.substring(lastColon + 1) : null) != null) {
            this.addField(doc, SearchableFields.FlowFileUUID, sourceFlowFileUUID);
        }
        return doc;
    }

    private static class UnIndexedLongField
    extends Field {
        static final FieldType TYPE = new FieldType();

        public UnIndexedLongField(String name, long value) {
            super(name, (IndexableFieldType)TYPE);
            this.fieldsData = value;
        }

        static {
            TYPE.setIndexOptions(IndexOptions.NONE);
            TYPE.setTokenized(true);
            TYPE.setOmitNorms(true);
            TYPE.setDocValuesType(DocValuesType.NUMERIC);
            TYPE.setStored(true);
            TYPE.freeze();
        }
    }
}

