/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.parquet;

import java.io.IOException;
import java.util.Optional;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.parquet.filter.OffsetRecordFilter;
import org.apache.nifi.parquet.hadoop.AvroParquetHDFSRecordReader;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.hadoop.AbstractFetchHDFSRecord;
import org.apache.nifi.processors.hadoop.record.HDFSRecordReader;
import org.apache.nifi.processors.parquet.PutParquet;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"parquet", "hadoop", "HDFS", "get", "ingest", "fetch", "source", "record"})
@CapabilityDescription(value="Reads from a given Parquet file and writes records to the content of the flow file using the selected record writer. The original Parquet file will remain unchanged, and the content of the flow file will be replaced with records of the selected type. This processor can be used with ListHDFS or ListFile to obtain a listing of files to fetch.")
@WritesAttributes(value={@WritesAttribute(attribute="fetch.failure.reason", description="When a FlowFile is routed to 'failure', this attribute is added indicating why the file could not be fetched from the given filesystem."), @WritesAttribute(attribute="record.count", description="The number of records in the resulting flow file"), @WritesAttribute(attribute="hadoop.file.url", description="The hadoop url for the file is stored in this attribute.")})
@ReadsAttributes(value={@ReadsAttribute(attribute="record.offset", description="Gets the index of first record in the input."), @ReadsAttribute(attribute="record.count", description="Gets the number of records in the input.")})
@SeeAlso(value={PutParquet.class})
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.READ_DISTRIBUTED_FILESYSTEM, explanation="Provides operator the ability to retrieve any file that NiFi has access to in HDFS or the local filesystem.")})
public class FetchParquet
extends AbstractFetchHDFSRecord {
    public HDFSRecordReader createHDFSRecordReader(ProcessContext context, FlowFile flowFile, Configuration conf, Path path) throws IOException {
        Long offset = Optional.ofNullable(flowFile.getAttribute("record.offset")).map(Long::parseLong).orElse(null);
        Long count = Optional.ofNullable(flowFile.getAttribute("record.count")).map(Long::parseLong).orElse(null);
        long fileStartOffset = Optional.ofNullable(flowFile.getAttribute("parquet.file.range.startOffset")).map(Long::parseLong).orElse(0L);
        long fileEndOffset = Optional.ofNullable(flowFile.getAttribute("parquet.file.range.endOffset")).map(Long::parseLong).orElse(Long.MAX_VALUE);
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)conf);
        ParquetReader.Builder readerBuilder = AvroParquetReader.builder((InputFile)inputFile).withConf(conf).withFileRange(fileStartOffset, fileEndOffset);
        if (offset != null) {
            readerBuilder.withFilter(FilterCompat.get((UnboundRecordFilter)OffsetRecordFilter.offset(offset)));
        }
        return new AvroParquetHDFSRecordReader((ParquetReader<GenericRecord>)readerBuilder.build(), count);
    }
}

