/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parquet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.parquet.record.ParquetRecordReader;
import org.apache.nifi.parquet.utils.ParquetConfig;
import org.apache.nifi.parquet.utils.ParquetUtils;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;

@Tags(value={"parquet", "parse", "record", "row", "reader"})
@CapabilityDescription(value="Parses Parquet data and returns each Parquet record as a separate Record object. The schema will come from the Parquet data itself.")
public class ParquetReader
extends AbstractControllerService
implements RecordReaderFactory {
    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, long inputLength, ComponentLog logger) throws IOException {
        Configuration conf = new Configuration();
        ParquetConfig parquetConfig = ParquetUtils.createParquetConfig((PropertyContext)this.getConfigurationContext(), variables);
        ParquetUtils.applyCommonConfig(conf, parquetConfig);
        return new ParquetRecordReader(in, inputLength, conf, variables);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(ParquetUtils.AVRO_READ_COMPATIBILITY);
        return properties;
    }
}

