/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.opentelemetry.server;

import com.google.protobuf.Message;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.nifi.event.transport.configuration.TransportProtocol;
import org.apache.nifi.event.transport.netty.NettyEventServerFactory;
import org.apache.nifi.event.transport.netty.channel.LogExceptionChannelHandler;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.opentelemetry.server.HttpProtocolNegotiationHandler;

public class HttpServerFactory
extends NettyEventServerFactory {
    private static final String[] APPLICATION_PROTOCOLS = new String[]{"h2", "http/1.1"};
    private static final Set<String> SUPPORTED_CIPHER_SUITES = new LinkedHashSet<String>(Http2SecurityUtil.CIPHERS);

    public HttpServerFactory(ComponentLog log, BlockingQueue<Message> messages, InetAddress address, int port, SSLContext sslContext) {
        super(address, port, TransportProtocol.TCP);
        SSLParameters sslParameters = this.getApplicationSslParameters(sslContext);
        this.setSslParameters(sslParameters);
        this.setSslContext(sslContext);
        LogExceptionChannelHandler logExceptionChannelHandler = new LogExceptionChannelHandler(log);
        this.setHandlerSupplier(() -> Arrays.asList(new ChannelHandler[]{new HttpProtocolNegotiationHandler(log, messages), logExceptionChannelHandler}));
    }

    private SSLParameters getApplicationSslParameters(SSLContext sslContext) {
        SSLParameters sslParameters = sslContext.getDefaultSSLParameters();
        sslParameters.setApplicationProtocols(APPLICATION_PROTOCOLS);
        List<String> defaultCipherSuites = Arrays.asList(sslParameters.getCipherSuites());
        String[] cipherSuites = SupportedCipherSuiteFilter.INSTANCE.filterCipherSuites(defaultCipherSuites, defaultCipherSuites, SUPPORTED_CIPHER_SUITES);
        sslParameters.setCipherSuites(cipherSuites);
        return sslParameters;
    }
}

