/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.opentelemetry.encoding;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.nifi.processors.opentelemetry.encoding.RequestMapper;
import org.apache.nifi.processors.opentelemetry.encoding.StandardProtobufModule;

public class StandardRequestMapper
implements RequestMapper {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public StandardRequestMapper() {
        this.objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        StandardProtobufModule protobufModule = new StandardProtobufModule();
        this.objectMapper.registerModule((Module)protobufModule);
    }

    @Override
    public <T extends Message> T readValue(InputStream inputStream, Class<T> messageClass) throws IOException {
        Objects.requireNonNull(inputStream, "Input Stream required");
        Objects.requireNonNull(messageClass, "Message Class required");
        return (T)((Message)this.objectMapper.readValue(inputStream, messageClass));
    }

    @Override
    public void writeValue(OutputStream outputStream, Message message) throws IOException {
        Objects.requireNonNull(outputStream, "Output Stream required");
        Objects.requireNonNull(message, "Message required");
        this.objectMapper.writeValue(outputStream, (Object)message);
    }
}

