/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.opentelemetry.encoding;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import com.hubspot.jackson.datatype.protobuf.builtin.serializers.MessageSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.nifi.processors.opentelemetry.encoding.HexadecimalByteStringField;

public class TelemetryMessageSerializer
extends MessageSerializer {
    private static final Set<String> HEXADECIMAL_BYTE_STRING_FIELDS = Arrays.stream(HexadecimalByteStringField.values()).map(HexadecimalByteStringField::getField).collect(Collectors.toSet());

    protected TelemetryMessageSerializer(ProtobufJacksonConfig config) {
        super(config);
    }

    protected void writeValue(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        String jsonName = field.getJsonName();
        if (HEXADECIMAL_BYTE_STRING_FIELDS.contains(jsonName)) {
            ByteString byteString = (ByteString)value;
            String encoded = this.getEncodedByteString(byteString);
            generator.writeString(encoded);
        } else {
            super.writeValue(field, value, generator, serializerProvider);
        }
    }

    private String getEncodedByteString(ByteString byteString) {
        ByteBuffer buffer = byteString.asReadOnlyByteBuffer();
        return Hex.encodeHexString((ByteBuffer)buffer, (boolean)false);
    }
}

