/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.opentelemetry.encoding;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceRequest;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.nifi.processors.opentelemetry.encoding.ServiceRequestReader;

public class ProtobufServiceRequestReader
implements ServiceRequestReader {
    private final Parser<ExportLogsServiceRequest> logsServiceRequestParser = ExportLogsServiceRequest.parser();
    private final Parser<ExportMetricsServiceRequest> metricsServiceRequestParser = ExportMetricsServiceRequest.parser();
    private final Parser<ExportTraceServiceRequest> traceServiceRequestParser = ExportTraceServiceRequest.parser();

    @Override
    public <T extends Message> T read(InputStream inputStream, Class<T> requestType) {
        Objects.requireNonNull(inputStream, "Input Stream required");
        Objects.requireNonNull(requestType, "Request Type required");
        try {
            Object serviceRequest;
            if (ExportLogsServiceRequest.class.isAssignableFrom(requestType)) {
                serviceRequest = this.logsServiceRequestParser.parseFrom(inputStream);
            } else if (ExportMetricsServiceRequest.class.isAssignableFrom(requestType)) {
                serviceRequest = this.metricsServiceRequestParser.parseFrom(inputStream);
            } else if (ExportTraceServiceRequest.class.isAssignableFrom(requestType)) {
                serviceRequest = this.traceServiceRequestParser.parseFrom(inputStream);
            } else {
                throw new IllegalArgumentException(String.format("Service Request Class [%s] not supported", requestType.getName()));
            }
            return (T)((Message)requestType.cast(serviceRequest));
        }
        catch (InvalidProtocolBufferException e) {
            throw new UncheckedIOException("Request parsing failed", (IOException)((Object)e));
        }
    }
}

