/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.opentelemetry.encoding;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.nifi.processors.opentelemetry.encoding.RequestMapper;
import org.apache.nifi.processors.opentelemetry.encoding.ServiceRequestReader;
import org.apache.nifi.processors.opentelemetry.encoding.StandardRequestMapper;

public class JsonServiceRequestReader
implements ServiceRequestReader {
    private static final RequestMapper REQUEST_MAPPER = new StandardRequestMapper();

    @Override
    public <T extends Message> T read(InputStream inputStream, Class<T> requestType) {
        Objects.requireNonNull(inputStream, "Input Stream required");
        try {
            return REQUEST_MAPPER.readValue(inputStream, requestType);
        }
        catch (IOException e) {
            String message = String.format("JSON Request Type [%s] parsing failed", requestType.getName());
            throw new UncheckedIOException(message, e);
        }
    }
}

