/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mqtt.common;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.processors.mqtt.common.MqttVersion;
import org.apache.nifi.security.util.TlsConfiguration;

public class MqttClientProperties {
    private BrokerUriHolder brokerUriHolder;
    private String clientId;
    private MqttVersion mqttVersion;
    private int keepAliveInterval;
    private int connectionTimeout;
    private boolean cleanSession;
    private Long sessionExpiryInterval;
    private TlsConfiguration tlsConfiguration;
    private String lastWillTopic;
    private String lastWillMessage;
    private Boolean lastWillRetain;
    private Integer lastWillQos;
    private String username;
    private String password;

    public List<URI> getBrokerUris() {
        return this.brokerUriHolder.getBrokerUris();
    }

    public String getRawBrokerUris() {
        return this.brokerUriHolder.getRawBrokerUris();
    }

    public String getProvenanceFormattedBrokerUris() {
        return this.brokerUriHolder.getProvenanceFormattedUris();
    }

    public void setBrokerUris(List<URI> brokerUris) {
        this.brokerUriHolder = new BrokerUriHolder(brokerUris);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public MqttVersion getMqttVersion() {
        return this.mqttVersion;
    }

    public void setMqttVersion(MqttVersion mqttVersion) {
        this.mqttVersion = mqttVersion;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public Long getSessionExpiryInterval() {
        return this.sessionExpiryInterval;
    }

    public void setSessionExpiryInterval(Long sessionExpiryInterval) {
        this.sessionExpiryInterval = sessionExpiryInterval;
    }

    public TlsConfiguration getTlsConfiguration() {
        return this.tlsConfiguration;
    }

    public void setTlsConfiguration(TlsConfiguration tlsConfiguration) {
        this.tlsConfiguration = tlsConfiguration;
    }

    public String getLastWillTopic() {
        return this.lastWillTopic;
    }

    public void setLastWillTopic(String lastWillTopic) {
        this.lastWillTopic = lastWillTopic;
    }

    public String getLastWillMessage() {
        return this.lastWillMessage;
    }

    public void setLastWillMessage(String lastWillMessage) {
        this.lastWillMessage = lastWillMessage;
    }

    public Boolean getLastWillRetain() {
        return this.lastWillRetain;
    }

    public void setLastWillRetain(Boolean lastWillRetain) {
        this.lastWillRetain = lastWillRetain;
    }

    public Integer getLastWillQos() {
        return this.lastWillQos;
    }

    public void setLastWillQos(Integer lastWillQos) {
        this.lastWillQos = lastWillQos;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private static class BrokerUriHolder {
        private final List<URI> brokerUris;
        private final String rawBrokerUris;
        private final String provenanceFormattedUris;

        public BrokerUriHolder(List<URI> brokerUris) {
            this.brokerUris = brokerUris;
            this.rawBrokerUris = this.createRawUris(brokerUris);
            this.provenanceFormattedUris = this.createProvenanceFormattedUris(brokerUris);
        }

        public List<URI> getBrokerUris() {
            return this.brokerUris;
        }

        public String getRawBrokerUris() {
            return this.rawBrokerUris;
        }

        public String getProvenanceFormattedUris() {
            return this.provenanceFormattedUris;
        }

        private String createRawUris(List<URI> brokerUris) {
            return brokerUris.stream().map(URI::toString).collect(Collectors.joining(","));
        }

        private String createProvenanceFormattedUris(List<URI> brokerUris) {
            String base = this.createRawUris(brokerUris);
            if (brokerUris.size() > 1) {
                return "[" + base + "]";
            }
            return base;
        }
    }
}

