/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.File;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.kerberos.KerberosContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.state.MockStateManager;
import org.apache.nifi.util.MockComponentLog;
import org.apache.nifi.util.MockControllerServiceLookup;

public class MockControllerServiceInitializationContext
extends MockControllerServiceLookup
implements ControllerServiceInitializationContext,
ControllerServiceLookup,
NodeTypeProvider {
    private final String identifier;
    private final ComponentLog logger;
    private final StateManager stateManager;
    private volatile boolean isClustered;
    private volatile boolean isPrimaryNode;
    private final KerberosContext kerberosContext;

    public MockControllerServiceInitializationContext(ControllerService controllerService, String identifier) {
        this(controllerService, identifier, new MockStateManager(controllerService));
    }

    public MockControllerServiceInitializationContext(ControllerService controllerService, String identifier, StateManager stateManager) {
        this(controllerService, identifier, new MockComponentLog(identifier, controllerService), stateManager);
    }

    public MockControllerServiceInitializationContext(ControllerService controllerService, String identifier, ComponentLog logger, StateManager stateManager) {
        this(controllerService, identifier, logger, stateManager, null);
    }

    public MockControllerServiceInitializationContext(ControllerService controllerService, String identifier, ComponentLog logger, StateManager stateManager, KerberosContext kerberosContext) {
        this.identifier = identifier;
        this.logger = logger;
        this.stateManager = stateManager;
        this.kerberosContext = kerberosContext;
        this.addControllerService(controllerService, identifier);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getControllerServiceName(String serviceIdentifier) {
        return null;
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    public ComponentLog getLogger() {
        return this.logger;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public NodeTypeProvider getNodeTypeProvider() {
        return this;
    }

    public String getKerberosServicePrincipal() {
        return this.kerberosContext != null ? this.kerberosContext.getKerberosServicePrincipal() : null;
    }

    public File getKerberosServiceKeytab() {
        return this.kerberosContext != null ? this.kerberosContext.getKerberosServiceKeytab() : null;
    }

    public File getKerberosConfigurationFile() {
        return this.kerberosContext != null ? this.kerberosContext.getKerberosConfigurationFile() : null;
    }

    public boolean isClustered() {
        return this.isClustered;
    }

    public boolean isPrimary() {
        return this.isPrimaryNode;
    }

    public void setClustered(boolean clustered) {
        this.isClustered = clustered;
    }

    public void setPrimaryNode(boolean primaryNode) {
        if (!this.isClustered && primaryNode) {
            throw new IllegalArgumentException("Primary node is only available in cluster. Use setClustered(true) first.");
        }
        this.isPrimaryNode = primaryNode;
    }
}

