/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.metrics.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.JvmAttributeGaugeSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.processor.DataUnit;

public class JmxJvmMetrics
implements JvmMetrics {
    static final String REGISTRY_METRICSET_JVM_ATTRIBUTES = "jvm-attributes";
    static final String REGISTRY_METRICSET_MEMORY = "memory";
    public static final String MEMORY_POOLS = "memory.pools";
    static final String REGISTRY_METRICSET_THREADS = "threads";
    static final String REGISTRY_METRICSET_GARBAGE_COLLECTORS = "garbage-collectors";
    static final String JVM_ATTRIBUTES_NAME = "jvm-attributes.name";
    static final String JVM_ATTRIBUTES_UPTIME = "jvm-attributes.uptime";
    static final String JVM_ATTRIBUTES_VENDOR = "jvm-attributes.vendor";
    static final String MEMORY_TOTAL_INIT = "memory.total.init";
    static final String MEMORY_TOTAL_USED = "memory.total.used";
    static final String MEMORY_TOTAL_MAX = "memory.total.max";
    static final String MEMORY_TOTAL_COMMITTED = "memory.total.committed";
    static final String MEMORY_HEAP_INIT = "memory.heap.init";
    static final String MEMORY_HEAP_USED = "memory.heap.used";
    static final String MEMORY_HEAP_MAX = "memory.heap.max";
    static final String MEMORY_HEAP_COMMITTED = "memory.heap.committed";
    static final String MEMORY_HEAP_USAGE = "memory.heap.usage";
    static final String MEMORY_NON_HEAP_USAGE = "memory.non-heap.usage";
    static final String THREADS_COUNT = "threads.count";
    static final String THREADS_DAEMON_COUNT = "threads.daemon.count";
    static final String THREADS_DEADLOCKS = "threads.deadlocks";
    static final String OS_FILEDESCRIPTOR_USAGE = "os.filedescriptor.usage";
    private static AtomicReference<MetricRegistry> metricRegistry = new AtomicReference<Object>(null);

    private JmxJvmMetrics() {
    }

    public static JmxJvmMetrics getInstance() {
        if (metricRegistry.get() == null) {
            metricRegistry.set(new MetricRegistry());
            metricRegistry.get().register(REGISTRY_METRICSET_JVM_ATTRIBUTES, (Metric)new JvmAttributeGaugeSet());
            metricRegistry.get().register(REGISTRY_METRICSET_MEMORY, (Metric)new MemoryUsageGaugeSet());
            metricRegistry.get().register(REGISTRY_METRICSET_THREADS, (Metric)new ThreadStatesGaugeSet());
            metricRegistry.get().register(REGISTRY_METRICSET_GARBAGE_COLLECTORS, (Metric)new GarbageCollectorMetricSet());
            metricRegistry.get().register(OS_FILEDESCRIPTOR_USAGE, (Metric)new FileDescriptorRatioGauge());
        }
        return new JmxJvmMetrics();
    }

    private Object getMetric(String metricName) {
        SortedMap gauges = metricRegistry.get().getGauges((name, metric) -> name.equals(metricName));
        if (gauges.isEmpty()) {
            throw new IllegalArgumentException(String.format("Unable to retrieve metric \"%s\"", metricName));
        }
        return ((Gauge)gauges.get(metricName)).getValue();
    }

    public Set<String> getMetricNames(String metricNamePrefix) {
        if (metricNamePrefix == null || metricNamePrefix.length() == 0) {
            throw new IllegalArgumentException("A metric name prefix must be supplied");
        }
        Object normalizedMetricNamePrefix = metricNamePrefix.endsWith(".") ? metricNamePrefix : metricNamePrefix + ".";
        return metricRegistry.get().getNames().stream().filter(arg_0 -> JmxJvmMetrics.lambda$getMetricNames$1((String)normalizedMetricNamePrefix, arg_0)).map(arg_0 -> JmxJvmMetrics.lambda$getMetricNames$2((String)normalizedMetricNamePrefix, arg_0)).collect(Collectors.toSet());
    }

    @Override
    public double totalInit(DataUnit dataUnit) {
        return (dataUnit == null ? DataUnit.B : dataUnit).convert((double)((Long)this.getMetric(MEMORY_TOTAL_INIT)).longValue(), DataUnit.B);
    }

    @Override
    public double totalUsed(DataUnit dataUnit) {
        return (dataUnit == null ? DataUnit.B : dataUnit).convert((double)((Long)this.getMetric(MEMORY_TOTAL_USED)).longValue(), DataUnit.B);
    }

    @Override
    public double totalMax(DataUnit dataUnit) {
        return (dataUnit == null ? DataUnit.B : dataUnit).convert((double)((Long)this.getMetric(MEMORY_TOTAL_MAX)).longValue(), DataUnit.B);
    }

    @Override
    public double totalCommitted(DataUnit dataUnit) {
        return (dataUnit == null ? DataUnit.B : dataUnit).convert((double)((Long)this.getMetric(MEMORY_TOTAL_COMMITTED)).longValue(), DataUnit.B);
    }

    @Override
    public double heapInit(DataUnit dataUnit) {
        return (dataUnit == null ? DataUnit.B : dataUnit).convert((double)((Long)this.getMetric(MEMORY_HEAP_INIT)).longValue(), DataUnit.B);
    }

    @Override
    public double heapUsed(DataUnit dataUnit) {
        return (dataUnit == null ? DataUnit.B : dataUnit).convert((double)((Long)this.getMetric(MEMORY_HEAP_USED)).longValue(), DataUnit.B);
    }

    @Override
    public double heapMax(DataUnit dataUnit) {
        return (dataUnit == null ? DataUnit.B : dataUnit).convert((double)((Long)this.getMetric(MEMORY_HEAP_MAX)).longValue(), DataUnit.B);
    }

    @Override
    public double heapCommitted(DataUnit dataUnit) {
        return (dataUnit == null ? DataUnit.B : dataUnit).convert((double)((Long)this.getMetric(MEMORY_HEAP_COMMITTED)).longValue(), DataUnit.B);
    }

    @Override
    public double heapUsage() {
        double usage = (Double)this.getMetric(MEMORY_HEAP_USAGE);
        return usage < 0.0 ? -1.0 : usage;
    }

    @Override
    public double nonHeapUsage() {
        double usage = (Double)this.getMetric(MEMORY_NON_HEAP_USAGE);
        return usage < 0.0 ? -1.0 : usage;
    }

    @Override
    public Map<String, Double> memoryPoolUsage() {
        Set<String> poolNames = this.getMetricNames(MEMORY_POOLS);
        HashMap<String, Double> memoryPoolUsage = new HashMap<String, Double>();
        for (String poolName : poolNames) {
            memoryPoolUsage.put(poolName, (Double)this.getMetric("memory.pools." + poolName + ".usage"));
        }
        return Collections.unmodifiableMap(memoryPoolUsage);
    }

    @Override
    public double fileDescriptorUsage() {
        return (Double)this.getMetric(OS_FILEDESCRIPTOR_USAGE);
    }

    @Override
    public String version() {
        return (String)this.getMetric(JVM_ATTRIBUTES_VENDOR);
    }

    @Override
    public String name() {
        return (String)this.getMetric(JVM_ATTRIBUTES_NAME);
    }

    @Override
    public long uptime() {
        return TimeUnit.MILLISECONDS.toSeconds((Long)this.getMetric(JVM_ATTRIBUTES_UPTIME));
    }

    @Override
    public int threadCount() {
        return (Integer)this.getMetric(THREADS_COUNT);
    }

    @Override
    public int daemonThreadCount() {
        return (Integer)this.getMetric(THREADS_DAEMON_COUNT);
    }

    @Override
    public Map<String, JvmMetrics.GarbageCollectorStats> garbageCollectors() {
        Set<String> garbageCollectors = this.getMetricNames(REGISTRY_METRICSET_GARBAGE_COLLECTORS);
        HashMap<String, JvmMetrics.GarbageCollectorStats> gcStats = new HashMap<String, JvmMetrics.GarbageCollectorStats>();
        for (String garbageCollector : garbageCollectors) {
            gcStats.put(garbageCollector, new JvmMetrics.GarbageCollectorStats((Long)this.getMetric("garbage-collectors." + garbageCollector + ".count"), (Long)this.getMetric("garbage-collectors." + garbageCollector + ".time")));
        }
        return Collections.unmodifiableMap(gcStats);
    }

    @Override
    public Set<String> deadlockedThreads() {
        return (Set)this.getMetric(THREADS_DEADLOCKS);
    }

    @Override
    public Map<Thread.State, Double> threadStatePercentages() {
        int totalThreadCount = (Integer)this.getMetric(THREADS_COUNT);
        HashMap<Thread.State, Double> threadStatePercentages = new HashMap<Thread.State, Double>();
        for (Thread.State state : Thread.State.values()) {
            threadStatePercentages.put(state, (double)((Integer)this.getMetric("threads." + state.name().toLowerCase() + ".count")).intValue() / (double)totalThreadCount);
        }
        return Collections.unmodifiableMap(threadStatePercentages);
    }

    @Override
    public void threadDump(OutputStream out) {
        throw new UnsupportedOperationException("This operation has not yet been implemented");
    }

    @Override
    public Map<String, JvmMetrics.BufferPoolStats> getBufferPoolStats() {
        throw new UnsupportedOperationException("This operation has not yet been implemented");
    }

    private static /* synthetic */ String lambda$getMetricNames$2(String normalizedMetricNamePrefix, String name) {
        return name.substring(normalizedMetricNamePrefix.length(), name.indexOf(".", normalizedMetricNamePrefix.length()));
    }

    private static /* synthetic */ boolean lambda$getMetricNames$1(String normalizedMetricNamePrefix, String name) {
        return name.startsWith(normalizedMetricNamePrefix);
    }
}

