/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.metrics.reporting.task;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.metrics.FlowMetricSet;
import org.apache.nifi.metrics.reporting.reporter.service.MetricReporterService;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.ReportingInitializationContext;

@Tags(value={"metrics", "reporting"})
@CapabilityDescription(value="This reporting task reports a set of metrics regarding the JVM and the NiFi instanceto a reporter. The reporter is provided by a MetricReporterService. It can be optionally used for a specificprocess group if a property with the group id is provided.")
@DeprecationNotice(reason="Unmaintained and planned for removal in version 2.0")
public class MetricsReportingTask
extends AbstractReportingTask {
    protected static final PropertyDescriptor REPORTER_SERVICE = new PropertyDescriptor.Builder().name("metric reporter service").displayName("Metric Reporter Service").description("The service that provides a reporter for the gathered metrics").identifiesControllerService(MetricReporterService.class).required(true).build();
    protected static final PropertyDescriptor PROCESS_GROUP_ID = new PropertyDescriptor.Builder().name("process group id").displayName("Process Group ID").description("The id of the process group to report. If not specified, metrics of the root process groupare reported.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private MetricRegistry metricRegistry;
    private ScheduledReporter reporter;
    protected AtomicReference<ProcessGroupStatus> currentStatusReference;

    protected void init(ReportingInitializationContext config) {
        this.metricRegistry = new MetricRegistry();
        this.currentStatusReference = new AtomicReference();
        this.metricRegistry.registerAll((MetricSet)new MemoryUsageGaugeSet());
        this.metricRegistry.registerAll((MetricSet)new FlowMetricSet(this.currentStatusReference));
    }

    @OnScheduled
    public void connect(ConfigurationContext context) {
        if (this.reporter == null) {
            this.reporter = ((MetricReporterService)context.getProperty(REPORTER_SERVICE).asControllerService()).createReporter(this.metricRegistry);
        }
    }

    public void onTrigger(ReportingContext context) {
        ProcessGroupStatus statusToReport;
        String groupId = context.getProperty(PROCESS_GROUP_ID).evaluateAttributeExpressions().getValue();
        ProcessGroupStatus processGroupStatus = statusToReport = groupId == null ? context.getEventAccess().getControllerStatus() : context.getEventAccess().getGroupStatus(groupId);
        if (statusToReport != null) {
            this.currentStatusReference.set(statusToReport);
            this.reporter.report();
        } else {
            this.getLogger().error("Process group with provided group id could not be found.");
        }
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(REPORTER_SERVICE);
        properties.add(PROCESS_GROUP_ID);
        return Collections.unmodifiableList(properties);
    }
}

