/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.maprsasl;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.nifi.util.hpe.HpePropertiesURLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedMaprSecurityLoginModule
implements LoginModule {
    private static final Logger logger = LoggerFactory.getLogger(IsolatedMaprSecurityLoginModule.class);
    private final LoginModule originLoginModule;

    public IsolatedMaprSecurityLoginModule() {
        try {
            String moduleName = IsolatedMaprSecurityLoginModule.getMaprSecurityLoginModuleName();
            logger.debug("Initializing MapR Security LoginModule using class: {}", (Object)moduleName);
            HpePropertiesURLClassLoader hpeClassLoader = new HpePropertiesURLClassLoader();
            Class moduleClass = hpeClassLoader.loadClass(moduleName);
            this.originLoginModule = (LoginModule)moduleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            logger.debug("Successfully instantiated MapR Security LoginModule: {}", (Object)moduleName);
        }
        catch (ClassNotFoundException e) {
            logger.error("MapR Security LoginModule class not found", (Throwable)e);
            throw new RuntimeException("Unable to load MapR Security LoginModule class", e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("Failed to instantiate MapR Security LoginModule", (Throwable)e);
            throw new RuntimeException("Unable to instantiate MapR Security LoginModule", e);
        }
    }

    private static String getMaprSecurityLoginModuleName() {
        String commonLoginModuleClassNme = "com.mapr.security.maprsasl.MaprSecurityLoginModule";
        String defaultZookeeperClientConfiguration = "Client";
        logger.debug("Looking up MapR Security LoginModule in JAAS entry '{}'", (Object)"Client");
        AppConfigurationEntry[] zookeeperClientConfiguration = Configuration.getConfiguration().getAppConfigurationEntry("Client");
        if (zookeeperClientConfiguration != null) {
            if (zookeeperClientConfiguration.length > 1) {
                logger.debug("JAAS entry {} has more that 1 login module", (Object)"Client");
            } else {
                return zookeeperClientConfiguration[0].getLoginModuleName();
            }
        }
        logger.debug("No suitable LoginModule found in JAAS entry '{}'; falling back to default MapR class name: {}", (Object)"Client", (Object)"com.mapr.security.maprsasl.MaprSecurityLoginModule");
        return "com.mapr.security.maprsasl.MaprSecurityLoginModule";
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.originLoginModule.initialize(subject, callbackHandler, sharedState, options);
    }

    @Override
    public boolean login() throws LoginException {
        return this.originLoginModule.login();
    }

    @Override
    public boolean commit() throws LoginException {
        return this.originLoginModule.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        return this.originLoginModule.abort();
    }

    @Override
    public boolean logout() throws LoginException {
        return this.originLoginModule.logout();
    }
}

