/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.nifi.security.maprsasl.IsolatedMaprSecurityLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasConfigWrapper
extends Configuration {
    private static final Logger logger = LoggerFactory.getLogger(JaasConfigWrapper.class);
    private final Configuration baseConfig;
    private final String targetEntryName;
    private final String wrapperEntryName;
    private AppConfigurationEntry[] wrappedEntry;

    public JaasConfigWrapper(Configuration baseConfig, String targetEntryName, String wrapperEntryName) {
        this.baseConfig = baseConfig;
        this.targetEntryName = targetEntryName;
        this.wrapperEntryName = wrapperEntryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        if (this.wrapperEntryName.equals(name)) {
            if (this.wrappedEntry == null) {
                JaasConfigWrapper jaasConfigWrapper = this;
                synchronized (jaasConfigWrapper) {
                    if (this.wrappedEntry == null) {
                        this.wrappedEntry = this.buildWrapperEntry();
                    }
                }
            }
            return (AppConfigurationEntry[])this.wrappedEntry.clone();
        }
        return this.baseConfig.getAppConfigurationEntry(name);
    }

    private AppConfigurationEntry[] buildWrapperEntry() {
        AppConfigurationEntry[] clientEntries = this.baseConfig.getAppConfigurationEntry(this.targetEntryName);
        if (clientEntries == null || clientEntries.length == 0) {
            throw new IllegalStateException(String.format("'%s' configuration not found in JAAS config", this.targetEntryName));
        }
        HashMap options = new HashMap(clientEntries[0].getOptions());
        return new AppConfigurationEntry[]{new AppConfigurationEntry(IsolatedMaprSecurityLoginModule.class.getName(), clientEntries[0].getControlFlag(), options)};
    }

    public static void setAsJaasConfig(Configuration baseConfig, String targetEntryName, String wrapperEntryName) {
        Configuration.setConfiguration(new JaasConfigWrapper(baseConfig, targetEntryName, wrapperEntryName));
    }

    public static synchronized void wrapDefaultConfig(String targetEntryName, String wrapperEntryName) {
        if (!Configuration.getConfiguration().getClass().equals(JaasConfigWrapper.class)) {
            JaasConfigWrapper.setAsJaasConfig(Configuration.getConfiguration(), targetEntryName, wrapperEntryName);
        } else {
            logger.debug("Configuration instance is already a JaasConfigWrapper. Will not wrap it");
        }
    }
}

