/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup.configuration2;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SafeXMLConfiguration
extends XMLConfiguration {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String DISALLOW_DOCTYPES = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String ALLOW_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String ALLOW_EXTERNAL_PARAM_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String ALLOW_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String XXE_ERROR_MESSAGE = "XML configuration file contained an external entity. To prevent XXE vulnerabilities, NiFi has external entity processing disabled.";

    public SafeXMLConfiguration() {
    }

    public SafeXMLConfiguration(HierarchicalConfiguration<ImmutableNode> c) {
        super(c);
    }

    public void initFileLocator(FileLocator loc) {
        super.initFileLocator(loc);
    }

    public DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        if (this.getDocumentBuilder() != null) {
            return this.getDocumentBuilder();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (this.isValidating()) {
            factory.setValidating(true);
            if (this.isSchemaValidation()) {
                factory.setNamespaceAware(true);
                factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
        }
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setAttribute(DISALLOW_DOCTYPES, true);
        factory.setAttribute(ALLOW_EXTERNAL_GENERAL_ENTITIES, false);
        factory.setAttribute(ALLOW_EXTERNAL_PARAM_ENTITIES, false);
        factory.setAttribute(ALLOW_EXTERNAL_DTD, false);
        DocumentBuilder result = factory.newDocumentBuilder();
        result.setEntityResolver(super.getEntityResolver());
        if (this.isValidating()) {
            result.setErrorHandler(new DefaultHandler(){

                @Override
                public void error(SAXParseException ex) throws SAXException {
                    throw ex;
                }
            });
        }
        return result;
    }

    public void read(Reader in) throws ConfigurationException, IOException {
        this.delegateRead(() -> super.read(in));
    }

    public void read(InputStream in) throws ConfigurationException, IOException {
        this.delegateRead(() -> super.read(in));
    }

    private void delegateRead(XMLReader superRead) throws ConfigurationException, IOException {
        try {
            superRead.read();
        }
        catch (ConfigurationException e) {
            if (this.isXXERelatedException(e)) {
                throw new ConfigurationException(XXE_ERROR_MESSAGE, (Throwable)e);
            }
            throw e;
        }
    }

    private boolean isXXERelatedException(ConfigurationException e) {
        return e.getCause() instanceof SAXParseException && e.getCause().getMessage().contains("DOCTYPE is disallowed");
    }

    @FunctionalInterface
    static interface XMLReader {
        public void read() throws ConfigurationException, IOException;
    }
}

