/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup.db;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.StringLookupService;
import org.apache.nifi.lookup.db.AbstractDatabaseLookupService;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.util.Tuple;

@Tags(value={"lookup", "cache", "enrich", "join", "rdbms", "database", "reloadable", "key", "value"})
@CapabilityDescription(value="A relational-database-based lookup service. When the lookup key is found in the database, the specified lookup value column is returned. Only one value will be returned for each lookup, duplicate database entries are ignored.")
public class SimpleDatabaseLookupService
extends AbstractDatabaseLookupService
implements StringLookupService {
    private volatile Cache<Tuple<String, Object>, String> cache;
    static final PropertyDescriptor LOOKUP_VALUE_COLUMN = new PropertyDescriptor.Builder().name("lookup-value-column").displayName("Lookup Value Column").description("The column whose value will be returned when the Lookup value is matched").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();

    protected void init(ControllerServiceInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(DBCP_SERVICE);
        properties.add(TABLE_NAME);
        properties.add(LOOKUP_KEY_COLUMN);
        properties.add(LOOKUP_VALUE_COLUMN);
        properties.add(CACHE_SIZE);
        properties.add(CLEAR_CACHE_ON_ENABLED);
        properties.add(CACHE_EXPIRATION);
        this.properties = Collections.unmodifiableList(properties);
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        long durationNanos;
        this.dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
        this.lookupKeyColumn = context.getProperty(LOOKUP_KEY_COLUMN).evaluateAttributeExpressions().getValue();
        int cacheSize = context.getProperty(CACHE_SIZE).evaluateAttributeExpressions().asInteger();
        boolean clearCache = context.getProperty(CLEAR_CACHE_ON_ENABLED).asBoolean();
        long l = durationNanos = context.getProperty(CACHE_EXPIRATION).isSet() ? context.getProperty(CACHE_EXPIRATION).evaluateAttributeExpressions().asTimePeriod(TimeUnit.NANOSECONDS) : 0L;
        if (this.cache == null || cacheSize > 0 && clearCache) {
            this.cache = durationNanos > 0L ? Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfter((Expiry)new Expiry<Tuple<String, Object>, Object>(){

                public long expireAfterCreate(Tuple<String, Object> stringObjectTuple, Object value, long currentTime) {
                    return durationNanos;
                }

                public long expireAfterUpdate(Tuple<String, Object> stringObjectTuple, Object value, long currentTime, long currentDuration) {
                    return currentDuration;
                }

                public long expireAfterRead(Tuple<String, Object> stringObjectTuple, Object value, long currentTime, long currentDuration) {
                    return currentDuration;
                }
            }).build() : Caffeine.newBuilder().maximumSize((long)cacheSize).build();
        }
    }

    public Optional<String> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        return this.lookup(coordinates, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> lookup(Map<String, Object> coordinates, Map<String, String> context) throws LookupFailureException {
        if (coordinates == null) {
            return Optional.empty();
        }
        Object key = coordinates.get("key");
        if (StringUtils.isBlank((CharSequence)key.toString())) {
            return Optional.empty();
        }
        String tableName = this.getProperty(TABLE_NAME).evaluateAttributeExpressions(context).getValue();
        String lookupValueColumn = this.getProperty(LOOKUP_VALUE_COLUMN).evaluateAttributeExpressions(context).getValue();
        Tuple cacheLookupKey = new Tuple((Object)tableName, key);
        String foundRecord = (String)this.cache.get((Object)cacheLookupKey, k -> null);
        if (foundRecord != null) return Optional.ofNullable(foundRecord);
        String selectQuery = "SELECT " + lookupValueColumn + " FROM " + tableName + " WHERE " + this.lookupKeyColumn + " = ?";
        try (Connection con = this.dbcpService.getConnection(context);
             PreparedStatement st = con.prepareStatement(selectQuery);){
            st.setObject(1, key);
            ResultSet resultSet = st.executeQuery();
            if (!resultSet.next()) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            Object o = resultSet.getObject(lookupValueColumn);
            if (o == null) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            foundRecord = o.toString();
            if (foundRecord == null) return Optional.ofNullable(foundRecord);
            this.cache.put((Object)cacheLookupKey, (Object)foundRecord);
            return Optional.ofNullable(foundRecord);
        }
        catch (SQLException se) {
            String string;
            String string2 = key.toString();
            if (se.getCause() == null) {
                string = se.getMessage();
                throw new LookupFailureException("Error executing SQL statement: " + selectQuery + "for value " + string2 + " : " + string, (Throwable)se);
            }
            string = se.getCause().getMessage();
            throw new LookupFailureException("Error executing SQL statement: " + selectQuery + "for value " + string2 + " : " + string, (Throwable)se);
        }
    }

    public Set<String> getRequiredKeys() {
        return REQUIRED_KEYS;
    }
}

