/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.key.service.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.security.PrivateKey;
import org.apache.nifi.key.service.reader.PrivateKeyException;
import org.apache.nifi.key.service.reader.PrivateKeyReader;
import org.bouncycastle.shaded.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.shaded.openssl.PEMDecryptorProvider;
import org.bouncycastle.shaded.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.shaded.openssl.PEMException;
import org.bouncycastle.shaded.openssl.PEMKeyPair;
import org.bouncycastle.shaded.openssl.PEMParser;
import org.bouncycastle.shaded.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.shaded.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.shaded.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.shaded.operator.InputDecryptorProvider;
import org.bouncycastle.shaded.operator.OperatorCreationException;
import org.bouncycastle.shaded.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.shaded.pkcs.PKCSException;

public class BouncyCastlePrivateKeyReader
implements PrivateKeyReader {
    private static final String INVALID_PEM = "Invalid PEM";

    @Override
    public PrivateKey readPrivateKey(InputStream inputStream, char[] keyPassword) {
        PrivateKey privateKey;
        PEMParser parser = new PEMParser((Reader)new InputStreamReader(inputStream));
        try {
            PrivateKeyInfo privateKeyInfo;
            Object object = parser.readObject();
            if (object instanceof PrivateKeyInfo) {
                privateKeyInfo = (PrivateKeyInfo)object;
            } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)object;
                privateKeyInfo = this.readEncryptedPrivateKey(encryptedPrivateKeyInfo, keyPassword);
            } else if (object instanceof PEMKeyPair) {
                PEMKeyPair pemKeyPair = (PEMKeyPair)object;
                privateKeyInfo = pemKeyPair.getPrivateKeyInfo();
            } else if (object instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)object;
                privateKeyInfo = this.readEncryptedPrivateKey(encryptedKeyPair, keyPassword);
            } else {
                String objectType = object == null ? INVALID_PEM : object.getClass().getName();
                String message = String.format("Private Key [%s] not supported", objectType);
                throw new IllegalArgumentException(message);
            }
            privateKey = this.convertPrivateKey(privateKeyInfo);
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Read Private Key stream failed", e);
            }
        }
        parser.close();
        return privateKey;
    }

    private PrivateKeyInfo readEncryptedPrivateKey(PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, char[] keyPassword) {
        try {
            InputDecryptorProvider provider = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(keyPassword);
            return encryptedPrivateKeyInfo.decryptPrivateKeyInfo(provider);
        }
        catch (OperatorCreationException e) {
            throw new PrivateKeyException("Preparing Private Key Decryption failed", e);
        }
        catch (PKCSException e) {
            throw new PrivateKeyException("Decrypting Private Key failed", e);
        }
    }

    private PrivateKeyInfo readEncryptedPrivateKey(PEMEncryptedKeyPair encryptedKeyPair, char[] keyPassword) {
        PEMDecryptorProvider provider = new JcePEMDecryptorProviderBuilder().build(keyPassword);
        try {
            PEMKeyPair pemKeyPair = encryptedKeyPair.decryptKeyPair(provider);
            return pemKeyPair.getPrivateKeyInfo();
        }
        catch (IOException e) {
            throw new PrivateKeyException("Decrypting Private Key Pair failed", e);
        }
    }

    private PrivateKey convertPrivateKey(PrivateKeyInfo privateKeyInfo) {
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        try {
            return converter.getPrivateKey(privateKeyInfo);
        }
        catch (PEMException e) {
            throw new PrivateKeyException("Convert Private Key failed", e);
        }
    }
}

