/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.login;

import javax.security.auth.login.AppConfigurationEntry;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;
import org.apache.nifi.kafka.shared.login.LoginConfigBuilder;
import org.apache.nifi.kafka.shared.login.LoginConfigProvider;

public class ScramLoginConfigProvider
implements LoginConfigProvider {
    private static final String MODULE_CLASS_NAME = "org.apache.kafka.common.security.scram.ScramLoginModule";
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    private static final String TOKEN_AUTH_KEY = "tokenauth";

    @Override
    public String getConfiguration(PropertyContext context) {
        LoginConfigBuilder builder = new LoginConfigBuilder(MODULE_CLASS_NAME, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED);
        String username = context.getProperty(KafkaClientComponent.SASL_USERNAME).evaluateAttributeExpressions().getValue();
        String password = context.getProperty(KafkaClientComponent.SASL_PASSWORD).evaluateAttributeExpressions().getValue();
        builder.append(USERNAME_KEY, username);
        builder.append(PASSWORD_KEY, password);
        Boolean tokenAuthenticationEnabled = context.getProperty(KafkaClientComponent.TOKEN_AUTHENTICATION).asBoolean();
        if (Boolean.TRUE == tokenAuthenticationEnabled) {
            builder.append(TOKEN_AUTH_KEY, Boolean.TRUE);
        }
        return builder.build();
    }
}

