/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.jslt;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.schibsted.spt.data.jslt.Expression;
import com.schibsted.spt.data.jslt.Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.util.StopWatch;

@SideEffectFree
@SupportsBatching
@Tags(value={"json", "jslt", "transform"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@SystemResourceConsideration(resource=SystemResource.MEMORY)
@WritesAttribute(attribute="mime.type", description="Always set to application/json")
@CapabilityDescription(value="Applies a JSLT transformation to the FlowFile JSON payload. A new FlowFile is created with transformed content and is routed to the 'success' relationship. If the JSLT transform fails, the original FlowFile is routed to the 'failure' relationship.")
public class JSLTTransformJSON
extends AbstractProcessor {
    public static final PropertyDescriptor JSLT_TRANSFORM = new PropertyDescriptor.Builder().name("jslt-transform-transformation").displayName("JSLT Transformation").description("JSLT Transformation for transform of JSON data. Any NiFi Expression Language present will be evaluated first to get the final transform to be applied. The JSLT Tutorial provides an overview of supported expressions: https://github.com/schibsted/jslt/blob/master/tutorial.md").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.TEXT, new ResourceType[]{ResourceType.FILE}).required(true).build();
    public static final PropertyDescriptor PRETTY_PRINT = new PropertyDescriptor.Builder().name("jslt-transform-pretty_print").displayName("Pretty Print").description("Apply pretty-print formatting to the output of the JSLT transform").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor TRANSFORM_CACHE_SIZE = new PropertyDescriptor.Builder().name("jslt-transform-cache-size").displayName("Transform Cache Size").description("Compiling a JSLT Transform can be fairly expensive. Ideally, this will be done only once. However, if the Expression Language is used in the transform, we may need a new Transform for each FlowFile. This value controls how many of those Transforms we cache in memory in order to avoid having to compile the Transform each time.").expressionLanguageSupported(ExpressionLanguageScope.NONE).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("1").required(true).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The FlowFile with transformed content will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If a FlowFile fails processing for any reason (for example, the FlowFile is not valid JSON), it will be routed to this relationship").build();
    private static final List<PropertyDescriptor> descriptors;
    private static final Set<Relationship> relationships;
    private static final ObjectMapper jsonObjectMapper;
    private Cache<String, Expression> transformCache;

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return descriptors;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        ValidationResult.Builder transformBuilder = new ValidationResult.Builder().subject(JSLT_TRANSFORM.getDisplayName());
        PropertyValue transformProperty = validationContext.getProperty(JSLT_TRANSFORM);
        if (transformProperty.isExpressionLanguagePresent()) {
            transformBuilder.valid(true);
        } else {
            try {
                String transform = this.readTransform(transformProperty);
                Parser.compileString((String)transform);
                transformBuilder.valid(true);
            }
            catch (RuntimeException e) {
                String explanation = String.format("JSLT Transform not valid: %s", e.getMessage());
                transformBuilder.valid(false).explanation(explanation);
            }
        }
        results.add(transformBuilder.build());
        return results;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        int maxTransformsToCache = context.getProperty(TRANSFORM_CACHE_SIZE).asInteger();
        this.transformCache = Caffeine.newBuilder().maximumSize((long)maxTransformsToCache).build();
        PropertyValue transformProperty = context.getProperty(JSLT_TRANSFORM);
        if (!transformProperty.isExpressionLanguagePresent()) {
            try {
                String transform = this.readTransform(transformProperty);
                this.transformCache.put((Object)transform, (Object)Parser.compileString((String)transform));
            }
            catch (RuntimeException e) {
                throw new ProcessException("JSLT Transform compilation failed", (Throwable)e);
            }
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        JsonNode jsonNode;
        FlowFile original = session.get();
        if (original == null) {
            return;
        }
        StopWatch stopWatch = new StopWatch(true);
        try (InputStream in = session.read(original);){
            jsonNode = this.readJson(in);
        }
        catch (Exception e) {
            this.getLogger().error("JSLT Transform failed {}", new Object[]{original, e});
            session.transfer(original, REL_FAILURE);
            return;
        }
        PropertyValue transformProperty = context.getProperty(JSLT_TRANSFORM);
        try {
            JsonNode outputObject;
            ObjectWriter writer;
            String transform = this.readTransform(transformProperty, original);
            Expression jsltExpression = (Expression)this.transformCache.get((Object)transform, currString -> Parser.compileString((String)transform));
            JsonNode transformedJson = jsltExpression.apply(jsonNode);
            ObjectWriter objectWriter = writer = context.getProperty(PRETTY_PRINT).asBoolean() != false ? jsonObjectMapper.writerWithDefaultPrettyPrinter() : jsonObjectMapper.writer();
            if (transformedJson == null || transformedJson.isNull()) {
                this.getLogger().warn("JSLT Transform resulted in no data {}", new Object[]{original});
                outputObject = null;
            } else {
                outputObject = transformedJson;
            }
            FlowFile transformed = session.write(original, out -> {
                if (outputObject != null) {
                    writer.writeValue(out, outputObject);
                }
            });
            transformed = session.putAttribute(transformed, CoreAttributes.MIME_TYPE.key(), "application/json");
            session.transfer(transformed, REL_SUCCESS);
            session.getProvenanceReporter().modifyContent(transformed, "Modified With " + transform, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            this.getLogger().debug("JSLT Transform completed {}", new Object[]{original});
        }
        catch (Exception e) {
            this.getLogger().error("JSLT Transform failed {}", new Object[]{original, e});
            session.transfer(original, REL_FAILURE);
        }
    }

    @OnStopped
    @OnShutdown
    public void onStopped(ProcessContext context) {
        this.transformCache.cleanUp();
    }

    private JsonNode readJson(InputStream in) throws IOException {
        try {
            return jsonObjectMapper.readTree(in);
        }
        catch (JsonParseException e) {
            throw new IOException("Could not parse data as JSON", e);
        }
    }

    private String readTransform(PropertyValue propertyValue, FlowFile flowFile) {
        String transform = propertyValue.isExpressionLanguagePresent() ? propertyValue.evaluateAttributeExpressions(flowFile).getValue() : this.readTransform(propertyValue);
        return transform;
    }

    private String readTransform(PropertyValue propertyValue) {
        String string;
        ResourceReference resourceReference = propertyValue.asResource();
        BufferedReader reader = new BufferedReader(new InputStreamReader(resourceReference.read()));
        try {
            string = reader.lines().collect(Collectors.joining());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Read JSLT Transform failed", e);
            }
        }
        reader.close();
        return string;
    }

    static {
        jsonObjectMapper = new ObjectMapper();
        descriptors = Collections.unmodifiableList(Arrays.asList(JSLT_TRANSFORM, PRETTY_PRINT, TRANSFORM_CACHE_SIZE));
        relationships = Collections.unmodifiableSet(new LinkedHashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    }
}

