/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import org.apache.nifi.logging.ComponentLog;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.core.JmsTemplate;

abstract class JMSWorker {
    protected final JmsTemplate jmsTemplate;
    protected final ComponentLog processLog;
    private final CachingConnectionFactory connectionFactory;
    private boolean isValid = true;

    public JMSWorker(CachingConnectionFactory connectionFactory, JmsTemplate jmsTemplate, ComponentLog processLog) {
        this.connectionFactory = connectionFactory;
        this.jmsTemplate = jmsTemplate;
        this.processLog = processLog;
    }

    public void shutdown() {
        this.connectionFactory.destroy();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[destination:" + this.jmsTemplate.getDefaultDestinationName() + "; pub-sub:" + this.jmsTemplate.isPubSubDomain() + ";]";
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }
}

