/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.NiFiServer;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.controller.DecommissionTask;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSynchronizationException;
import org.apache.nifi.controller.status.history.StatusHistoryDumpFactory;
import org.apache.nifi.diagnostics.DiagnosticsDump;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.DiagnosticsFactory;
import org.apache.nifi.diagnostics.ThreadDumpTask;
import org.apache.nifi.documentation.DocGenerator;
import org.apache.nifi.flow.resource.ExternalResourceDescriptor;
import org.apache.nifi.flow.resource.ExternalResourceProvider;
import org.apache.nifi.flow.resource.ExternalResourceProviderInitializationContext;
import org.apache.nifi.flow.resource.ExternalResourceProviderService;
import org.apache.nifi.flow.resource.ExternalResourceProviderServiceBuilder;
import org.apache.nifi.flow.resource.NarProviderAdapter;
import org.apache.nifi.flow.resource.PropertyBasedExternalResourceProviderInitializationContext;
import org.apache.nifi.lifecycle.LifeCycleStartException;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.ExtensionManagerHolder;
import org.apache.nifi.nar.ExtensionMapping;
import org.apache.nifi.nar.ExtensionUiLoader;
import org.apache.nifi.nar.NarAutoLoader;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.nar.NarLoader;
import org.apache.nifi.nar.NarProvider;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.apache.nifi.nar.NarUnpackMode;
import org.apache.nifi.nar.StandardExtensionDiscoveringManager;
import org.apache.nifi.nar.StandardNarLoader;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.ui.extension.UiExtension;
import org.apache.nifi.ui.extension.UiExtensionMapping;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.ContentAccess;
import org.apache.nifi.web.NiFiWebConfigurationContext;
import org.apache.nifi.web.UiExtensionType;
import org.apache.nifi.web.server.HostHeaderHandler;
import org.apache.nifi.web.server.connector.FrameworkServerConnectorFactory;
import org.apache.nifi.web.server.filter.FilterParameter;
import org.apache.nifi.web.server.filter.RequestFilterProvider;
import org.apache.nifi.web.server.filter.RestApiRequestFilterProvider;
import org.apache.nifi.web.server.filter.StandardRequestFilterProvider;
import org.apache.nifi.web.server.log.StandardRequestLogProvider;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.ee10.servlet.DefaultServlet;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class JettyServer
implements NiFiServer,
ExtensionUiLoader {
    private static final Logger logger = LoggerFactory.getLogger(JettyServer.class);
    private static final String ALLOWED_CONTEXT_PATHS_PARAMETER = "allowedContextPaths";
    private static final String CONTAINER_JAR_PATTERN = ".*/jetty-jakarta-servlet-api-[^/]*\\.jar$|.*jakarta.servlet.jsp.jstl-[^/]*\\.jar";
    private static final String CONTEXT_PATH_ALL = "/*";
    private static final String CONTEXT_PATH_ROOT = "/";
    private static final String CONTEXT_PATH_NIFI = "/nifi";
    private static final String CONTEXT_PATH_NIFI_API = "/nifi-api";
    private static final String CONTEXT_PATH_NIFI_CONTENT_VIEWER = "/nifi-content-viewer";
    private static final String CONTEXT_PATH_NIFI_DOCS = "/nifi-docs";
    private static final RequestFilterProvider REQUEST_FILTER_PROVIDER = new StandardRequestFilterProvider();
    private static final RequestFilterProvider REST_API_REQUEST_FILTER_PROVIDER = new RestApiRequestFilterProvider();
    private static final String NAR_PROVIDER_PREFIX = "nifi.nar.library.provider.";
    private static final String NAR_PROVIDER_POLL_INTERVAL_PROPERTY = "nifi.nar.library.poll.interval";
    private static final String NAR_PROVIDER_CONFLICT_RESOLUTION = "nifi.nar.library.conflict.resolution";
    private static final String NAR_PROVIDER_RESTRAIN_PROPERTY = "nifi.nar.library.restrain.startup";
    private static final String NAR_PROVIDER_IMPLEMENTATION_PROPERTY = "implementation";
    private static final String DEFAULT_NAR_PROVIDER_POLL_INTERVAL = "5 min";
    private static final String DEFAULT_NAR_PROVIDER_CONFLICT_RESOLUTION = "IGNORE";
    private static final String NAR_DEPENDENCIES_PATH = "NAR-INF/bundled-dependencies";
    private static final String WAR_EXTENSION = ".war";
    private static final int WEB_APP_MAX_FORM_CONTENT_SIZE = 600000;
    private static final String APPLICATION_URL_FORMAT = "%s://%s:%d/nifi";
    private static final String HTTPS_SCHEME = "https";
    private static final String HTTP_SCHEME = "http";
    private static final String HOST_UNSPECIFIED = "0.0.0.0";
    private final DeploymentManager deploymentManager = new DeploymentManager();
    private Server server;
    private NiFiProperties props;
    private Bundle systemBundle;
    private Set<Bundle> bundles;
    private ExtensionMapping extensionMapping;
    private NarAutoLoader narAutoLoader;
    private ExternalResourceProviderService narProviderService;
    private DiagnosticsFactory diagnosticsFactory;
    private DecommissionTask decommissionTask;
    private StatusHistoryDumpFactory statusHistoryDumpFactory;
    private WebAppContext webApiContext;
    private WebAppContext webDocsContext;
    private WebAppContext webContentViewerContext;
    private Collection<WebAppContext> contentViewerWebContexts;
    private UiExtensionMapping componentUiExtensions;
    private Collection<WebAppContext> componentUiExtensionWebContexts;

    public void init() {
        QueuedThreadPool threadPool = new QueuedThreadPool(this.props.getWebThreads());
        threadPool.setName("NiFi Web Server");
        this.server = new Server((ThreadPool)threadPool);
        this.configureConnectors(this.server);
        ContextHandlerCollection handlerCollection = new ContextHandlerCollection(new ContextHandler[0]);
        if (this.props.isHTTPSConfigured()) {
            HostHeaderHandler hostHeaderHandler = new HostHeaderHandler(this.props);
            handlerCollection.addHandler((Handler)hostHeaderHandler);
        }
        Handler warHandlers = this.loadInitialWars(this.bundles);
        handlerCollection.addHandler(warHandlers);
        this.server.setHandler((Handler)handlerCollection);
        this.deploymentManager.setContexts(handlerCollection);
        this.server.addBean((Object)this.deploymentManager);
        String requestLogFormat = this.props.getProperty("nifi.web.request.log.format");
        StandardRequestLogProvider requestLogProvider = new StandardRequestLogProvider(requestLogFormat);
        RequestLog requestLog = requestLogProvider.getRequestLog();
        this.server.setRequestLog(requestLog);
    }

    private Handler loadInitialWars(Set<Bundle> bundles) {
        Map<File, Bundle> warToBundleLookup = this.findWars(bundles);
        File webUiWar = null;
        File webApiWar = null;
        File webErrorWar = null;
        File webDocsWar = null;
        File webContentViewerWar = null;
        HashMap<File, Bundle> otherWars = new HashMap<File, Bundle>();
        for (Map.Entry<File, Bundle> warBundleEntry : warToBundleLookup.entrySet()) {
            File war = warBundleEntry.getKey();
            Bundle warBundle = warBundleEntry.getValue();
            if (war.getName().toLowerCase().startsWith("nifi-web-api")) {
                webApiWar = war;
                continue;
            }
            if (war.getName().toLowerCase().startsWith("nifi-web-error")) {
                webErrorWar = war;
                continue;
            }
            if (war.getName().toLowerCase().startsWith("nifi-web-docs")) {
                webDocsWar = war;
                continue;
            }
            if (war.getName().toLowerCase().startsWith("nifi-web-content-viewer")) {
                webContentViewerWar = war;
                continue;
            }
            if (war.getName().toLowerCase().startsWith("nifi-web")) {
                webUiWar = war;
                continue;
            }
            otherWars.put(war, warBundle);
        }
        if (webUiWar == null) {
            throw new RuntimeException("Unable to load nifi-web WAR");
        }
        if (webApiWar == null) {
            throw new RuntimeException("Unable to load nifi-web-api WAR");
        }
        if (webDocsWar == null) {
            throw new RuntimeException("Unable to load nifi-web-docs WAR");
        }
        if (webErrorWar == null) {
            throw new RuntimeException("Unable to load nifi-web-error WAR");
        }
        if (webContentViewerWar == null) {
            throw new RuntimeException("Unable to load nifi-web-content-viewer WAR");
        }
        ExtensionUiInfo extensionUiInfo = this.loadWars(otherWars);
        this.componentUiExtensionWebContexts = new ArrayList<WebAppContext>(extensionUiInfo.componentUiExtensionWebContexts());
        this.contentViewerWebContexts = new ArrayList<WebAppContext>(extensionUiInfo.contentViewerWebContexts());
        this.componentUiExtensions = new UiExtensionMapping(extensionUiInfo.componentUiExtensionsByType());
        ContextHandlerCollection webAppContextHandlers = new ContextHandlerCollection(new ContextHandler[0]);
        Collection<WebAppContext> extensionUiContexts = extensionUiInfo.webAppContexts();
        extensionUiContexts.forEach(arg_0 -> ((ContextHandlerCollection)webAppContextHandlers).addHandler(arg_0));
        ClassLoader frameworkClassLoader = this.getClass().getClassLoader();
        WebAppContext webUiContext = this.loadWar(webUiWar, CONTEXT_PATH_NIFI, frameworkClassLoader);
        webUiContext.getInitParams().put("oidc-supported", String.valueOf(this.props.isOidcEnabled()));
        webUiContext.getInitParams().put("knox-supported", String.valueOf(this.props.isKnoxSsoEnabled()));
        webUiContext.getInitParams().put("saml-supported", String.valueOf(this.props.isSamlEnabled()));
        webUiContext.getInitParams().put("saml-single-logout-supported", String.valueOf(this.props.isSamlSingleLogoutEnabled()));
        webUiContext.getInitParams().put("login-provider-supported", String.valueOf(this.props.isLoginIdentityProviderEnabled()));
        webAppContextHandlers.addHandler((Handler)webUiContext);
        this.webApiContext = this.loadWar(webApiWar, CONTEXT_PATH_NIFI_API, frameworkClassLoader);
        webAppContextHandlers.addHandler((Handler)this.webApiContext);
        this.webContentViewerContext = this.loadWar(webContentViewerWar, CONTEXT_PATH_NIFI_CONTENT_VIEWER, frameworkClassLoader);
        this.webContentViewerContext.getInitParams().putAll(extensionUiInfo.mimeMappings());
        extensionUiInfo.contentViewerServletContexts.forEach((contextPath, servletContext) -> this.webContentViewerContext.setAttribute(contextPath, servletContext));
        webAppContextHandlers.addHandler((Handler)this.webContentViewerContext);
        this.webDocsContext = this.loadWar(webDocsWar, CONTEXT_PATH_NIFI_DOCS, frameworkClassLoader);
        this.addDocsServlets(this.webDocsContext);
        webAppContextHandlers.addHandler((Handler)this.webDocsContext);
        WebAppContext webErrorContext = this.loadWar(webErrorWar, CONTEXT_PATH_ROOT, frameworkClassLoader);
        webAppContextHandlers.addHandler((Handler)webErrorContext);
        return webAppContextHandlers;
    }

    public void loadExtensionUis(Set<Bundle> bundles) {
        Map<File, Bundle> warToBundleLookup = this.findWars(bundles);
        ExtensionUiInfo extensionUiInfo = this.loadWars(warToBundleLookup);
        Collection<WebAppContext> webAppContexts = extensionUiInfo.webAppContexts();
        if (webAppContexts.isEmpty()) {
            logger.debug("Extension User Interface Web Applications not found");
            return;
        }
        for (WebAppContext webAppContext : webAppContexts) {
            Path warPath = Paths.get(webAppContext.getWar(), new String[0]);
            App extensionUiApp = new App(this.deploymentManager, null, warPath);
            this.deploymentManager.addApp(extensionUiApp);
        }
        Collection<WebAppContext> componentUiExtensionWebContexts = extensionUiInfo.componentUiExtensionWebContexts();
        Collection<WebAppContext> contentViewerWebContexts = extensionUiInfo.contentViewerWebContexts();
        ServletContext webApiServletContext = this.webApiContext.getServletHandler().getServletContext();
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)webApiServletContext);
        NiFiWebConfigurationContext configurationContext = (NiFiWebConfigurationContext)webApplicationContext.getBean("nifiWebConfigurationContext", NiFiWebConfigurationContext.class);
        FilterHolder securityFilter = this.webApiContext.getServletHandler().getFilter("springSecurityFilterChain");
        this.performInjectionForComponentUis(componentUiExtensionWebContexts, configurationContext, securityFilter);
        this.performInjectionForContentViewerUis(contentViewerWebContexts, securityFilter);
        this.componentUiExtensionWebContexts.addAll(componentUiExtensionWebContexts);
        this.contentViewerWebContexts.addAll(contentViewerWebContexts);
        this.componentUiExtensions.addUiExtensions(extensionUiInfo.componentUiExtensionsByType());
        for (WebAppContext webAppContext : webAppContexts) {
            Throwable unavailableException = webAppContext.getUnavailableException();
            if (unavailableException == null) {
                logger.debug("Web Application [{}] loaded", (Object)webAppContext);
                continue;
            }
            logger.error("Web Application [{}] unavailable after initialization", (Object)webAppContext, (Object)unavailableException);
        }
    }

    private ExtensionUiInfo loadWars(Map<File, Bundle> warToBundleLookup) {
        ArrayList<WebAppContext> webAppContexts = new ArrayList<WebAppContext>();
        HashMap<String, String> mimeMappings = new HashMap<String, String>();
        ArrayList<WebAppContext> componentUiExtensionWebContexts = new ArrayList<WebAppContext>();
        ArrayList<WebAppContext> contentViewerWebContexts = new ArrayList<WebAppContext>();
        HashMap<String, List<UiExtension>> componentUiExtensionsByType = new HashMap<String, List<UiExtension>>();
        HashMap<String, ServletContext> contentViewerServletContexts = new HashMap<String, ServletContext>();
        if (!warToBundleLookup.isEmpty()) {
            for (Map.Entry<File, Bundle> warBundleEntry : warToBundleLookup.entrySet()) {
                File war = warBundleEntry.getKey();
                Bundle warBundle = warBundleEntry.getValue();
                HashMap<UiExtensionType, List<String>> uiExtensionInWar = new HashMap<UiExtensionType, List<String>>();
                this.identifyUiExtensionsForComponents(uiExtensionInWar, war);
                if (uiExtensionInWar.isEmpty()) continue;
                String warName = StringUtils.substringBeforeLast((String)war.getName(), (String)".");
                String warContextPath = String.format("/%s", warName);
                ClassLoader narClassLoaderForWar = warBundle.getClassLoader();
                WebAppContext extensionUiContext = this.loadWar(war, warContextPath, narClassLoaderForWar);
                for (Map.Entry entry : uiExtensionInWar.entrySet()) {
                    UiExtensionType extensionType = (UiExtensionType)entry.getKey();
                    List types = (List)entry.getValue();
                    if (UiExtensionType.ContentViewer.equals((Object)extensionType)) {
                        for (String contentType : types) {
                            mimeMappings.put(contentType, warContextPath);
                        }
                        contentViewerWebContexts.add(extensionUiContext);
                        contentViewerServletContexts.put(warContextPath, extensionUiContext.getServletContext());
                        continue;
                    }
                    for (String componentTypeCoordinates : types) {
                        logger.info("Loading UI extension [{}, {}] for {}", new Object[]{extensionType, warContextPath, componentTypeCoordinates});
                        UiExtension uiExtension = new UiExtension(extensionType, warContextPath);
                        ArrayList<UiExtension> componentUiExtensionsForType = (ArrayList<UiExtension>)componentUiExtensionsByType.get(componentTypeCoordinates);
                        if (componentUiExtensionsForType == null) {
                            componentUiExtensionsForType = new ArrayList<UiExtension>();
                            componentUiExtensionsByType.put(componentTypeCoordinates, componentUiExtensionsForType);
                        }
                        if (this.containsUiExtensionType(componentUiExtensionsForType, extensionType)) {
                            throw new IllegalStateException(String.format("Encountered duplicate UI for %s", componentTypeCoordinates));
                        }
                        componentUiExtensionsForType.add(uiExtension);
                    }
                    componentUiExtensionWebContexts.add(extensionUiContext);
                }
                webAppContexts.add(extensionUiContext);
            }
        }
        return new ExtensionUiInfo(webAppContexts, mimeMappings, componentUiExtensionWebContexts, contentViewerWebContexts, componentUiExtensionsByType, contentViewerServletContexts);
    }

    private boolean containsUiExtensionType(List<UiExtension> componentUiExtensionsForType, UiExtensionType extensionType) {
        for (UiExtension uiExtension : componentUiExtensionsForType) {
            if (!extensionType.equals((Object)uiExtension.getExtensionType())) continue;
            return true;
        }
        return false;
    }

    private Map<File, Bundle> findWars(Set<Bundle> bundles) {
        HashMap<File, Bundle> wars = new HashMap<File, Bundle>();
        bundles.forEach(bundle -> {
            BundleDetails details = bundle.getBundleDetails();
            Path bundledDependencies = new File(details.getWorkingDirectory(), NAR_DEPENDENCIES_PATH).toPath();
            if (Files.isDirectory(bundledDependencies, new LinkOption[0])) {
                try (Stream<Path> dependencies = Files.list(bundledDependencies);){
                    dependencies.filter(dependency -> dependency.getFileName().toString().endsWith(WAR_EXTENSION)).map(Path::toFile).forEach(dependency -> wars.put((File)dependency, (Bundle)bundle));
                }
                catch (IOException e) {
                    logger.warn("Failed to find WAR files in bundled-dependencies [{}]", (Object)bundledDependencies, (Object)e);
                }
            }
        });
        return wars;
    }

    private void readUiExtensions(Map<UiExtensionType, List<String>> uiExtensions, UiExtensionType uiExtensionType, JarFile jarFile, JarEntry jarEntry) throws IOException {
        if (jarEntry == null) {
            return;
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(jarFile.getInputStream(jarEntry)));){
            String rawComponentType;
            while ((rawComponentType = in.readLine()) != null) {
                String componentType = this.extractComponentType(rawComponentType);
                if (componentType == null) continue;
                List<String> extensions = uiExtensions.get(uiExtensionType);
                if (extensions == null) {
                    extensions = new ArrayList<String>();
                    uiExtensions.put(uiExtensionType, extensions);
                }
                extensions.add(componentType);
            }
        }
    }

    private void identifyUiExtensionsForComponents(Map<UiExtensionType, List<String>> uiExtensions, File warFile) {
        try (JarFile jarFile = new JarFile(warFile);){
            this.readUiExtensions(uiExtensions, UiExtensionType.ContentViewer, jarFile, jarFile.getJarEntry("META-INF/nifi-content-viewer"));
            this.readUiExtensions(uiExtensions, UiExtensionType.ProcessorConfiguration, jarFile, jarFile.getJarEntry("META-INF/nifi-processor-configuration"));
            this.readUiExtensions(uiExtensions, UiExtensionType.ControllerServiceConfiguration, jarFile, jarFile.getJarEntry("META-INF/nifi-controller-service-configuration"));
            this.readUiExtensions(uiExtensions, UiExtensionType.ReportingTaskConfiguration, jarFile, jarFile.getJarEntry("META-INF/nifi-reporting-task-configuration"));
            this.readUiExtensions(uiExtensions, UiExtensionType.ParameterProviderConfiguration, jarFile, jarFile.getJarEntry("META-INF/nifi-parameter-provider-configuration"));
            this.readUiExtensions(uiExtensions, UiExtensionType.FlowRegistryClientConfiguration, jarFile, jarFile.getJarEntry("META-INF/nifi-flow-registry-client-configuration"));
        }
        catch (IOException ioe) {
            logger.warn(String.format("Unable to inspect %s for a UI extensions.", warFile));
        }
    }

    private String extractComponentType(String line) {
        String trimmedLine = line.trim();
        if (!trimmedLine.isEmpty() && !trimmedLine.startsWith("#")) {
            int indexOfPound = trimmedLine.indexOf("#");
            return indexOfPound > 0 ? trimmedLine.substring(0, indexOfPound) : trimmedLine;
        }
        return null;
    }

    private WebAppContext loadWar(File warFile, String contextPath, ClassLoader parentClassLoader) {
        WebAppContext webappContext = new WebAppContext(warFile.getPath(), contextPath);
        webappContext.getInitParams().put(ALLOWED_CONTEXT_PATHS_PARAMETER, this.props.getAllowedContextPaths());
        webappContext.setDisplayName(contextPath);
        webappContext.setMaxFormContentSize(600000);
        webappContext.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)CONTAINER_JAR_PATTERN);
        webappContext.setErrorHandler((Request.Handler)this.getErrorHandler());
        webappContext.setTempDirectory(this.getWebAppTempDirectory(warFile));
        List<FilterHolder> requestFilters = CONTEXT_PATH_NIFI_API.equals(contextPath) ? REST_API_REQUEST_FILTER_PROVIDER.getFilters(this.props) : REQUEST_FILTER_PROVIDER.getFilters(this.props);
        requestFilters.forEach(filter -> {
            String pathSpecification = filter.getInitParameter(FilterParameter.PATH_SPECIFICATION.name());
            String filterPathSpecification = pathSpecification == null ? CONTEXT_PATH_ALL : pathSpecification;
            webappContext.addFilter(filter, filterPathSpecification, EnumSet.allOf(DispatcherType.class));
        });
        webappContext.setClassLoader((ClassLoader)new WebAppClassLoader(parentClassLoader, (WebAppClassLoader.Context)webappContext));
        logger.info("Loading WAR [{}] Context Path [{}]", (Object)warFile.getAbsolutePath(), (Object)contextPath);
        return webappContext;
    }

    private File getWebAppTempDirectory(File warFile) {
        File tempDirectory = new File(this.props.getWebWorkingDirectory(), warFile.getName()).getAbsoluteFile();
        if (tempDirectory.exists() && !tempDirectory.isDirectory()) {
            throw new IllegalStateException("Web Application Temporary Directory [%s] is not a directory".formatted(tempDirectory));
        }
        if (!tempDirectory.exists()) {
            boolean created = tempDirectory.mkdirs();
            if (created) {
                logger.debug("Web Application Temporary Directory [{}] created", (Object)tempDirectory);
            } else {
                throw new IllegalStateException("Web Application Temporary Directory [%s] directory creation failed".formatted(tempDirectory));
            }
        }
        if (!tempDirectory.canRead()) {
            throw new IllegalStateException("Web Application Temporary Directory [%s] is missing read permission".formatted(tempDirectory));
        }
        if (!tempDirectory.canWrite()) {
            throw new IllegalStateException("Web Application Temporary Directory [%s] is missing write permissions".formatted(tempDirectory));
        }
        return tempDirectory;
    }

    private void addDocsServlets(WebAppContext docsContext) {
        try {
            File docsDir = this.getDocsDir();
            ServletHolder docs = new ServletHolder("docs", DefaultServlet.class);
            Path htmlBaseResource = docsDir.toPath().resolve("html");
            docs.setInitParameter("baseResource", htmlBaseResource.toString());
            docs.setInitParameter("dirAllowed", "false");
            docsContext.addServlet(docs, "/html/*");
            ServletHolder components = new ServletHolder("components", DefaultServlet.class);
            File componentDocsDirPath = this.props.getComponentDocumentationWorkingDirectory();
            File workingDocsDirectory = this.getWorkingDocsDirectory(componentDocsDirPath);
            Path componentsBaseResource = workingDocsDirectory.toPath().resolve("components");
            components.setInitParameter("baseResource", componentsBaseResource.toString());
            components.setInitParameter("dirAllowed", "false");
            docsContext.addServlet(components, "/components/*");
            ServletHolder restApi = new ServletHolder("rest-api", DefaultServlet.class);
            File webApiDocsDir = this.getWebApiDocsDir();
            restApi.setInitParameter("baseResource", webApiDocsDir.getPath());
            restApi.setInitParameter("dirAllowed", "false");
            docsContext.addServlet(restApi, "/rest-api/*");
            logger.info("Loading Docs [{}] Context Path [{}]", (Object)docsDir.getAbsolutePath(), (Object)docsContext.getContextPath());
        }
        catch (Exception ex) {
            logger.error("Unhandled Exception in createDocsWebApp: " + ex.getMessage());
            this.startUpFailure(ex);
        }
    }

    private File getDocsDir() {
        File docsDir;
        block2: {
            String docsDirectory = "docs";
            try {
                docsDir = Paths.get("docs", new String[0]).toRealPath(new LinkOption[0]).toFile();
            }
            catch (IOException ex) {
                logger.info("Directory 'docs' is missing. Some documentation will be unavailable.");
                docsDir = new File("docs").getAbsoluteFile();
                boolean made = docsDir.mkdirs();
                if (made) break block2;
                logger.error("Failed to create 'docs' directory!");
                this.startUpFailure(new IOException(docsDir.getAbsolutePath() + " could not be created"));
            }
        }
        return docsDir;
    }

    private File getWorkingDocsDirectory(File componentDocsDirPath) {
        File workingDocsDirectory = null;
        try {
            workingDocsDirectory = componentDocsDirPath.toPath().toRealPath(new LinkOption[0]).getParent().toFile();
        }
        catch (IOException e) {
            logger.error("Component Documentation Directory resolution failed [{}]", (Object)componentDocsDirPath, (Object)e);
            this.startUpFailure(e);
        }
        return workingDocsDirectory;
    }

    private File getWebApiDocsDir() {
        boolean made;
        File webApiDocsDir = new File(this.webApiContext.getTempDirectory(), "webapp/docs/rest-api");
        if (!webApiDocsDir.exists() && !(made = webApiDocsDir.mkdirs())) {
            logger.error("Failed to create " + webApiDocsDir.getAbsolutePath());
            this.startUpFailure(new IOException(webApiDocsDir.getAbsolutePath() + " could not be created"));
        }
        return webApiDocsDir;
    }

    private void configureConnectors(Server server) {
        try {
            FrameworkServerConnectorFactory serverConnectorFactory = new FrameworkServerConnectorFactory(server, this.props);
            Map interfaces = this.props.isHTTPSConfigured() ? this.props.getHttpsNetworkInterfaces() : this.props.getHttpNetworkInterfaces();
            Set interfaceNames = interfaces.values().stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            if (interfaceNames.isEmpty()) {
                String host2;
                ServerConnector serverConnector = serverConnectorFactory.getServerConnector();
                String string = host2 = this.props.isHTTPSConfigured() ? this.props.getProperty("nifi.web.https.host") : this.props.getProperty("nifi.web.http.host");
                if (StringUtils.isNotBlank((CharSequence)host2)) {
                    serverConnector.setHost(host2);
                }
                server.addConnector((Connector)serverConnector);
            } else {
                interfaceNames.stream().map(interfaceName -> {
                    try {
                        return NetworkInterface.getByName(interfaceName);
                    }
                    catch (SocketException e) {
                        throw new UncheckedIOException(String.format("Network Interface [%s] not found", interfaceName), e);
                    }
                }).filter(Objects::nonNull).flatMap(networkInterface -> Collections.list(networkInterface.getInetAddresses()).stream()).map(InetAddress::getHostAddress).map(host -> {
                    ServerConnector serverConnector = serverConnectorFactory.getServerConnector();
                    serverConnector.setHost(host);
                    return serverConnector;
                }).forEach(arg_0 -> ((Server)server).addConnector(arg_0));
            }
        }
        catch (Throwable e) {
            this.startUpFailure(e);
        }
    }

    protected List<URI> getApplicationUrls() {
        return Arrays.stream(this.server.getConnectors()).map(connector -> (ServerConnector)connector).map(serverConnector -> {
            SslConnectionFactory sslConnectionFactory = (SslConnectionFactory)serverConnector.getConnectionFactory(SslConnectionFactory.class);
            String scheme = sslConnectionFactory == null ? HTTP_SCHEME : HTTPS_SCHEME;
            int port = serverConnector.getLocalPort();
            String connectorHost = serverConnector.getHost();
            String host = (String)StringUtils.defaultIfEmpty((CharSequence)connectorHost, (CharSequence)HOST_UNSPECIFIED);
            return URI.create(String.format(APPLICATION_URL_FORMAT, scheme, host, port));
        }).collect(Collectors.toList());
    }

    public void start() {
        try {
            List<URI> applicationUrls;
            StandardExtensionDiscoveringManager extensionManager = new StandardExtensionDiscoveringManager();
            extensionManager.discoverExtensions(this.systemBundle, this.bundles);
            extensionManager.logClassLoaderMapping();
            ExtensionManagerHolder.init((ExtensionManager)extensionManager);
            DocGenerator.generate((NiFiProperties)this.props, (ExtensionManager)extensionManager, (ExtensionMapping)this.extensionMapping);
            this.narProviderService = new ExternalResourceProviderServiceBuilder("NAR Auto-Loader Provider", (ExtensionManager)extensionManager).providers(this.buildExternalResourceProviders((ExtensionManager)extensionManager, NAR_PROVIDER_PREFIX, descriptor -> descriptor.getLocation().toLowerCase().endsWith(".nar"))).targetDirectory(new File(this.props.getProperty("nifi.nar.library.autoload.directory", "./extensions"))).conflictResolutionStrategy(this.props.getProperty(NAR_PROVIDER_CONFLICT_RESOLUTION, DEFAULT_NAR_PROVIDER_CONFLICT_RESOLUTION)).pollInterval(this.props.getProperty(NAR_PROVIDER_POLL_INTERVAL_PROPERTY, DEFAULT_NAR_PROVIDER_POLL_INTERVAL)).restrainingStartup(Boolean.parseBoolean(this.props.getProperty(NAR_PROVIDER_RESTRAIN_PROPERTY, "true"))).build();
            this.narProviderService.start();
            NarUnpackMode unpackMode = this.props.isUnpackNarsToUberJar() ? NarUnpackMode.UNPACK_TO_UBER_JAR : NarUnpackMode.UNPACK_INDIVIDUAL_JARS;
            StandardNarLoader narLoader = new StandardNarLoader(this.props.getExtensionsWorkingDirectory(), this.props.getComponentDocumentationWorkingDirectory(), NarClassLoadersHolder.getInstance(), (ExtensionDiscoveringManager)extensionManager, this.extensionMapping, (ExtensionUiLoader)this, unpackMode);
            this.narAutoLoader = new NarAutoLoader(this.props, (NarLoader)narLoader);
            this.narAutoLoader.start();
            this.server.start();
            for (Handler handler : this.server.getHandlers()) {
                WebAppContext context;
                if (!(handler instanceof WebAppContext) || (context = (WebAppContext)handler).getUnavailableException() == null) continue;
                this.startUpFailure(context.getUnavailableException());
            }
            if (this.webApiContext != null) {
                ServletContext webApiServletContext = this.webApiContext.getServletHandler().getServletContext();
                webApiServletContext.setAttribute("nifi-ui-extensions", (Object)this.componentUiExtensions);
                WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)webApiServletContext);
                NiFiWebConfigurationContext configurationContext = (NiFiWebConfigurationContext)webApplicationContext.getBean("nifiWebConfigurationContext", NiFiWebConfigurationContext.class);
                FilterHolder securityFilter = this.webApiContext.getServletHandler().getFilter("springSecurityFilterChain");
                this.performInjectionForComponentUis(this.componentUiExtensionWebContexts, configurationContext, securityFilter);
                this.performInjectionForContentViewerUis(this.contentViewerWebContexts, securityFilter);
                if (this.webContentViewerContext != null) {
                    ContentAccess contentAccess = (ContentAccess)webApplicationContext.getBean("contentAccess", ContentAccess.class);
                    ServletContext webContentViewerServletContext = this.webContentViewerContext.getServletHandler().getServletContext();
                    webContentViewerServletContext.setAttribute("nifi-content-access", (Object)contentAccess);
                    if (securityFilter != null) {
                        this.webContentViewerContext.addFilter(securityFilter, CONTEXT_PATH_ALL, EnumSet.allOf(DispatcherType.class));
                    }
                }
                this.diagnosticsFactory = (DiagnosticsFactory)webApplicationContext.getBean("diagnosticsFactory", DiagnosticsFactory.class);
                this.decommissionTask = (DecommissionTask)webApplicationContext.getBean("decommissionTask", DecommissionTask.class);
                this.statusHistoryDumpFactory = (StatusHistoryDumpFactory)webApplicationContext.getBean("statusHistoryDumpFactory", StatusHistoryDumpFactory.class);
            }
            if (this.webDocsContext != null) {
                ServletContext webDocsServletContext = this.webDocsContext.getServletHandler().getServletContext();
                webDocsServletContext.setAttribute("nifi-extension-mapping", (Object)this.extensionMapping);
            }
            if (this.props.isNode()) {
                FlowService flowService = null;
                try {
                    WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.webApiContext.getServletContext());
                    flowService = (FlowService)((ApplicationContext)Objects.requireNonNull(ctx)).getBean("flowService", FlowService.class);
                    flowService.start();
                    flowService.load(null);
                }
                catch (IOException | UninheritableFlowException | FlowSerializationException | FlowSynchronizationException | LifeCycleStartException | BeansException e) {
                    if (flowService != null && flowService.isRunning()) {
                        flowService.stop(false);
                    }
                    logger.error("Failed to start Flow Service", e);
                    throw new Exception("Failed to start Flow Service" + (Exception)e);
                }
            }
            if ((applicationUrls = this.getApplicationUrls()).isEmpty()) {
                logger.warn("Started Server without connectors");
            } else {
                for (URI applicationUrl : applicationUrls) {
                    logger.info("Started Server on {}", (Object)applicationUrl);
                }
            }
        }
        catch (Exception ex) {
            this.startUpFailure(ex);
        }
    }

    public Map<String, ExternalResourceProvider> buildExternalResourceProviders(ExtensionManager extensionManager, String providerPropertyPrefix, Predicate<ExternalResourceDescriptor> filter) throws ClassNotFoundException, InstantiationException, IllegalAccessException, TlsException {
        HashMap<String, ExternalResourceProvider> result = new HashMap<String, ExternalResourceProvider>();
        Set externalSourceNames = this.props.getDirectSubsequentTokens(providerPropertyPrefix);
        for (String externalSourceName : externalSourceNames) {
            logger.info("External resource provider '{}' found in configuration", (Object)externalSourceName);
            String providerClass = this.props.getProperty(providerPropertyPrefix + externalSourceName + ".implementation");
            String providerId = UUID.randomUUID().toString();
            PropertyBasedExternalResourceProviderInitializationContext context = new PropertyBasedExternalResourceProviderInitializationContext(this.props, providerPropertyPrefix + externalSourceName + ".", filter);
            result.put(providerId, this.createProviderInstance(extensionManager, providerClass, providerId, (ExternalResourceProviderInitializationContext)context));
        }
        return result;
    }

    private ExternalResourceProvider createProviderInstance(ExtensionManager extensionManager, String providerClass, String providerId, ExternalResourceProviderInitializationContext context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ExternalResourceProvider provider;
        try {
            provider = (ExternalResourceProvider)NarThreadContextClassLoader.createInstance((ExtensionManager)extensionManager, (String)providerClass, ExternalResourceProvider.class, (NiFiProperties)this.props, (String)providerId);
        }
        catch (ClassCastException e) {
            logger.warn("Class {} does not implement ExternalResourceProvider falling back to NarProvider", (Object)providerClass);
            provider = new NarProviderAdapter((NarProvider)NarThreadContextClassLoader.createInstance((ExtensionManager)extensionManager, (String)providerClass, NarProvider.class, (NiFiProperties)this.props, (String)providerId));
        }
        provider.initialize(context);
        return provider;
    }

    public DiagnosticsFactory getDiagnosticsFactory() {
        return this.diagnosticsFactory == null ? this.getThreadDumpFactory() : this.diagnosticsFactory;
    }

    public DiagnosticsFactory getThreadDumpFactory() {
        return new ThreadDumpDiagnosticsFactory();
    }

    public DecommissionTask getDecommissionTask() {
        return this.decommissionTask;
    }

    public StatusHistoryDumpFactory getStatusHistoryDumpFactory() {
        return this.statusHistoryDumpFactory;
    }

    private void performInjectionForComponentUis(Collection<WebAppContext> componentUiExtensionWebContexts, NiFiWebConfigurationContext configurationContext, FilterHolder securityFilter) {
        for (WebAppContext customUiContext : componentUiExtensionWebContexts) {
            ServletContext customUiServletContext = customUiContext.getServletHandler().getServletContext();
            customUiServletContext.setAttribute("nifi-web-configuration-context", (Object)configurationContext);
            if (securityFilter == null) continue;
            customUiContext.addFilter(securityFilter, CONTEXT_PATH_ALL, EnumSet.allOf(DispatcherType.class));
        }
    }

    private void performInjectionForContentViewerUis(Collection<WebAppContext> contentViewerWebContexts, FilterHolder securityFilter) {
        for (WebAppContext contentViewerContext : contentViewerWebContexts) {
            if (securityFilter == null) continue;
            contentViewerContext.addFilter(securityFilter, CONTEXT_PATH_ALL, EnumSet.allOf(DispatcherType.class));
        }
    }

    private void startUpFailure(Throwable t) {
        System.err.println("Failed to start web server: " + t.getMessage());
        System.err.println("Shutting down...");
        logger.error("Failed to start web server... shutting down.", t);
        System.exit(1);
    }

    public void initialize(NiFiProperties properties, Bundle systemBundle, Set<Bundle> bundles, ExtensionMapping extensionMapping) {
        this.props = properties;
        this.systemBundle = systemBundle;
        this.bundles = bundles;
        this.extensionMapping = extensionMapping;
        this.init();
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            logger.warn("Failed to stop web server", (Throwable)ex);
        }
        try {
            if (this.narAutoLoader != null) {
                this.narAutoLoader.stop();
            }
        }
        catch (Exception e) {
            logger.warn("Failed to stop NAR auto-loader", (Throwable)e);
        }
        try {
            if (this.narProviderService != null) {
                this.narProviderService.stop();
            }
        }
        catch (Exception e) {
            logger.warn("Failed to stop NAR provider", (Throwable)e);
        }
    }

    private ErrorPageErrorHandler getErrorHandler() {
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.setShowServlet(false);
        errorHandler.setShowStacks(false);
        errorHandler.setShowMessageInTitle(false);
        return errorHandler;
    }

    private record ExtensionUiInfo(Collection<WebAppContext> webAppContexts, Map<String, String> mimeMappings, Collection<WebAppContext> componentUiExtensionWebContexts, Collection<WebAppContext> contentViewerWebContexts, Map<String, List<UiExtension>> componentUiExtensionsByType, Map<String, ServletContext> contentViewerServletContexts) {
    }

    private static class ThreadDumpDiagnosticsFactory
    implements DiagnosticsFactory {
        private ThreadDumpDiagnosticsFactory() {
        }

        public DiagnosticsDump create(boolean verbose) {
            return out -> {
                DiagnosticsDumpElement threadDumpElement = new ThreadDumpTask().captureDump(verbose);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
                for (String detail : threadDumpElement.getDetails()) {
                    writer.write(detail);
                    writer.write("\n");
                }
                writer.flush();
            };
        }
    }
}

