/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server.util;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.net.ssl.SSLContext;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class StoreScanner
extends ContainerLifeCycle
implements Scanner.DiscreteListener {
    private static final Logger LOG = Log.getLogger(StoreScanner.class);
    private final SslContextFactory sslContextFactory;
    private final TlsConfiguration tlsConfiguration;
    private final File file;
    private final Scanner scanner;
    private final String resourceName;

    public StoreScanner(SslContextFactory sslContextFactory, TlsConfiguration tlsConfiguration, Resource resource) {
        this.sslContextFactory = sslContextFactory;
        this.tlsConfiguration = tlsConfiguration;
        this.resourceName = resource.getName();
        try {
            File monitoredFile = resource.getFile();
            if (monitoredFile == null || !monitoredFile.exists()) {
                throw new IllegalArgumentException(String.format("%s file does not exist", this.resourceName));
            }
            if (monitoredFile.isDirectory()) {
                throw new IllegalArgumentException(String.format("expected %s file not directory", this.resourceName));
            }
            if (resource.getAlias() != null) {
                monitoredFile = new File(resource.getAlias());
            }
            this.file = monitoredFile;
            if (LOG.isDebugEnabled()) {
                LOG.debug("File monitoring started {} [{}]", new Object[]{this.resourceName, monitoredFile});
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("could not obtain %s file", this.resourceName), e);
        }
        File parentFile = this.file.getParentFile();
        if (!parentFile.exists() || !parentFile.isDirectory()) {
            throw new IllegalArgumentException(String.format("error obtaining %s dir", this.resourceName));
        }
        this.scanner = new Scanner();
        this.scanner.setScanDirs(Collections.singletonList(parentFile));
        this.scanner.setScanInterval(1);
        this.scanner.setReportDirs(false);
        this.scanner.setReportExistingFilesOnStartup(false);
        this.scanner.setScanDepth(1);
        this.scanner.addListener((Scanner.Listener)this);
        this.addBean(this.scanner);
    }

    public void fileAdded(String filename) {
        LOG.debug("Resource [{}] File [{}] added", new Object[]{this.resourceName, filename});
        this.reloadMatched(filename);
    }

    public void fileChanged(String filename) {
        LOG.debug("Resource [{}] File [{}] changed", new Object[]{this.resourceName, filename});
        this.reloadMatched(filename);
    }

    public void fileRemoved(String filename) {
        LOG.debug("Resource [{}] File [{}] removed", new Object[]{this.resourceName, filename});
        this.reloadMatched(filename);
    }

    @ManagedOperation(value="Scan for changes in the SSL Keystore/Truststore", impact="ACTION")
    public void scan() {
        LOG.debug("Resource [{}] scanning started", new Object[]{this.resourceName});
        this.scanner.scan();
        this.scanner.scan();
    }

    @ManagedOperation(value="Reload the SSL Keystore/Truststore", impact="ACTION")
    public void reload() {
        LOG.debug("File [{}] reload started", new Object[]{this.file});
        try {
            this.sslContextFactory.reload(contextFactory -> contextFactory.setSslContext(this.createContext()));
            LOG.info("File [{}] reload completed", new Object[]{this.file});
        }
        catch (Throwable t) {
            LOG.warn("File [{}] reload failed", new Object[]{this.file, t});
        }
    }

    @ManagedAttribute(value="scanning interval to detect changes which need reloaded")
    public int getScanInterval() {
        return this.scanner.getScanInterval();
    }

    public void setScanInterval(int scanInterval) {
        this.scanner.setScanInterval(scanInterval);
    }

    private void reloadMatched(String filename) {
        if (this.file.toPath().toString().equals(filename)) {
            this.reload();
        }
    }

    private SSLContext createContext() {
        try {
            return org.apache.nifi.security.util.SslContextFactory.createSslContext((TlsConfiguration)this.tlsConfiguration);
        }
        catch (TlsException e) {
            throw new IllegalArgumentException("Failed to create SSL context with the TLS configuration", e);
        }
    }
}

