/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.requests.ContentLengthFilter;
import org.apache.nifi.web.server.filter.DataTransferExcludedDoSFilter;
import org.apache.nifi.web.server.filter.RequestFilterProvider;
import org.apache.nifi.web.server.log.RequestAuthenticationFilter;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlets.DoSFilter;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.HeaderWriterFilter;
import org.springframework.security.web.header.writers.ContentSecurityPolicyHeaderWriter;
import org.springframework.security.web.header.writers.HstsHeaderWriter;
import org.springframework.security.web.header.writers.XContentTypeOptionsHeaderWriter;
import org.springframework.security.web.header.writers.XXssProtectionHeaderWriter;
import org.springframework.security.web.header.writers.frameoptions.XFrameOptionsHeaderWriter;

public class StandardRequestFilterProvider
implements RequestFilterProvider {
    private static final int MAX_CONTENT_SIZE_DISABLED = 0;
    private static final String STANDARD_CONTENT_POLICY = "frame-ancestors 'self'";

    @Override
    public List<FilterHolder> getFilters(NiFiProperties properties) {
        Objects.requireNonNull(properties, "Properties required");
        ArrayList<FilterHolder> filters = new ArrayList<FilterHolder>();
        if (properties.isHTTPSConfigured()) {
            filters.add(this.getFilterHolder(RequestAuthenticationFilter.class));
        }
        filters.add(this.getHeaderWriterFilter());
        int maxContentSize = this.getMaxContentSize(properties);
        if (maxContentSize > 0) {
            FilterHolder contentLengthFilter = this.getContentLengthFilter(maxContentSize);
            filters.add(contentLengthFilter);
        }
        FilterHolder denialOfServiceFilter = this.getDenialOfServiceFilter(properties, DataTransferExcludedDoSFilter.class);
        filters.add(denialOfServiceFilter);
        return filters;
    }

    protected FilterHolder getDenialOfServiceFilter(NiFiProperties properties, Class<? extends DoSFilter> filterClass) {
        FilterHolder filter = new FilterHolder(filterClass);
        int maxWebRequestsPerSecond = properties.getMaxWebRequestsPerSecond();
        filter.setInitParameter("maxRequestsPerSec", Integer.toString(maxWebRequestsPerSecond));
        long webRequestTimeout = this.getWebRequestTimeout(properties);
        filter.setInitParameter("maxRequestMs", Long.toString(webRequestTimeout));
        String webRequestIpWhitelist = properties.getWebRequestIpWhitelist();
        filter.setInitParameter("ipWhitelist", webRequestIpWhitelist);
        filter.setName(DoSFilter.class.getSimpleName());
        return filter;
    }

    private FilterHolder getHeaderWriterFilter() {
        List<HeaderWriter> headerWriters = Arrays.asList(new ContentSecurityPolicyHeaderWriter(STANDARD_CONTENT_POLICY), new HstsHeaderWriter(), new XContentTypeOptionsHeaderWriter(), new XFrameOptionsHeaderWriter(XFrameOptionsHeaderWriter.XFrameOptionsMode.SAMEORIGIN), new XXssProtectionHeaderWriter());
        HeaderWriterFilter headerWriterFilter = new HeaderWriterFilter(headerWriters);
        FilterHolder filterHolder = new FilterHolder((Filter)headerWriterFilter);
        filterHolder.setName(HeaderWriterFilter.class.getSimpleName());
        return filterHolder;
    }

    private FilterHolder getFilterHolder(Class<? extends Filter> filterClass) {
        FilterHolder filter = new FilterHolder(filterClass);
        filter.setName(filterClass.getSimpleName());
        return filter;
    }

    private FilterHolder getContentLengthFilter(int maxContentSize) {
        FilterHolder filter = this.getFilterHolder(ContentLengthFilter.class);
        filter.setInitParameter("maxContentLength", Integer.toString(maxContentSize));
        filter.setName(ContentLengthFilter.class.getSimpleName());
        return filter;
    }

    private int getMaxContentSize(NiFiProperties properties) {
        String webMaxContentSize = properties.getWebMaxContentSize();
        try {
            return StringUtils.isBlank((CharSequence)webMaxContentSize) ? 0 : DataUnit.parseDataSize((String)webMaxContentSize, (DataUnit)DataUnit.B).intValue();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("Property [%s] format invalid", "nifi.web.max.content.size"), e);
        }
    }

    protected long getWebRequestTimeout(NiFiProperties properties) {
        String webRequestTimeout = properties.getWebRequestTimeout();
        try {
            double webRequestTimeoutParsed = FormatUtils.getPreciseTimeDuration((String)webRequestTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
            return Math.round(webRequestTimeoutParsed);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("Property [%s] format invalid", "nifi.web.request.timeout"), e);
        }
    }
}

