/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.AbstractHTMLProcessor;
import org.apache.nifi.GetHTMLElement;
import org.apache.nifi.ModifyHTMLElement;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Tags(value={"put", "html", "dom", "css", "element"})
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Places a new HTML element in the existing HTML DOM. The desired position for the new HTML element is specified by using CSS selector syntax. The incoming HTML is first converted into a HTML Document Object Model so that HTML DOM location may be located in a similar manner that CSS selectors are used to apply styles to HTML. The resulting HTML DOM is then \"queried\" using the user defined CSS selector string to find the position where the user desires to add the new HTML element. Once the new HTML element is added to the DOM it is rendered to HTML and the result replaces the flowfile content with the updated HTML. A more thorough reference for the CSS selector syntax can be found at \"http://jsoup.org/apidocs/org/jsoup/select/Selector.html\"")
@SeeAlso(value={GetHTMLElement.class, ModifyHTMLElement.class})
public class PutHTMLElement
extends AbstractHTMLProcessor {
    public static final String APPEND_ELEMENT = "append-html";
    public static final String PREPEND_ELEMENT = "prepend-html";
    public static final PropertyDescriptor PUT_LOCATION_TYPE = new PropertyDescriptor.Builder().name("Element Insert Location Type").description("Controls whether the new element is prepended or appended to the children of the Element located by the CSS selector. EX: prepended value '<b>Hi</b>' inside of Element (using CSS Selector 'p') '<p>There</p>' would result in '<p><b>Hi</b>There</p>'. Appending the value would result in '<p>There<b>Hi</b></p>'").required(true).allowableValues(new String[]{"append-html", "prepend-html"}).defaultValue("append-html").build();
    public static final PropertyDescriptor PUT_VALUE = new PropertyDescriptor.Builder().name("Put Value").description("Value used when creating the new Element. Value should be a valid HTML element. The text should be supplied unencoded: characters like '<', '>', etc will be properly HTML encoded in the resulting output.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    private List<PropertyDescriptor> descriptors;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(CSS_SELECTOR);
        descriptors.add(HTML_CHARSET);
        descriptors.add(PUT_LOCATION_TYPE);
        descriptors.add(PUT_VALUE);
        this.descriptors = Collections.unmodifiableList(descriptors);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_ORIGINAL);
        relationships.add(REL_SUCCESS);
        relationships.add(REL_INVALID_HTML);
        relationships.add(REL_NOT_FOUND);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return URL;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        Elements eles;
        Document doc;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            doc = this.parseHTMLDocumentFromFlowfile(flowFile, context, session);
            eles = doc.select(context.getProperty(CSS_SELECTOR).evaluateAttributeExpressions(flowFile).getValue());
        }
        catch (Exception ex) {
            this.getLogger().error("Failed to extract HTML from {} due to {}; routing to {}", new Object[]{flowFile, ex.toString(), REL_INVALID_HTML.getName()}, (Throwable)ex);
            session.transfer(flowFile, REL_INVALID_HTML);
            return;
        }
        if (eles == null || eles.isEmpty()) {
            session.transfer(flowFile, REL_NOT_FOUND);
        } else {
            String putValue = context.getProperty(PUT_VALUE).evaluateAttributeExpressions(flowFile).getValue();
            for (Element ele : eles) {
                switch (context.getProperty(PUT_LOCATION_TYPE).getValue()) {
                    case "append-html": {
                        ele.append(putValue);
                        break;
                    }
                    case "prepend-html": {
                        ele.prepend(putValue);
                    }
                }
            }
            FlowFile ff = session.write(session.create(flowFile), new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    out.write(doc.html().getBytes(StandardCharsets.UTF_8));
                }
            });
            session.transfer(ff, REL_SUCCESS);
            session.transfer(flowFile, REL_ORIGINAL);
        }
    }
}

