/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.streaming;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.common.util.TimestampParser;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public class NiFiRecordSerDe
extends AbstractSerDe {
    protected RecordReader recordReader;
    protected ComponentLog log;
    protected List<String> columnNames;
    protected StructTypeInfo schema;
    protected SerDeStats stats;
    protected StandardStructObjectInspector cachedObjectInspector;
    protected TimestampParser tsParser;
    private static final Pattern INTERNAL_PATTERN = Pattern.compile("_col([0-9]+)");

    public NiFiRecordSerDe(RecordReader recordReader, ComponentLog log) {
        this.recordReader = recordReader;
        this.log = log;
    }

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        StructTypeInfo rowTypeInfo;
        this.log.debug("Initializing NiFiRecordSerDe: {}", tbl.entrySet().toArray());
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        String columnNameDelimiter = tbl.containsKey("column.name.delimiter") ? tbl.getProperty("column.name.delimiter") : String.valueOf(',');
        this.columnNames = columnNameProperty.isEmpty() ? new ArrayList<String>(0) : new ArrayList<String>(Arrays.asList(columnNameProperty.split(columnNameDelimiter)));
        ArrayList columnTypes = columnTypeProperty.isEmpty() ? new ArrayList(0) : TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        this.log.debug("columns: {}, {}", new Object[]{columnNameProperty, this.columnNames});
        this.log.debug("types: {}, {} ", new Object[]{columnTypeProperty, columnTypes});
        assert (this.columnNames.size() == columnTypes.size());
        this.schema = rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(this.columnNames, columnTypes);
        this.log.debug("schema : {}", new Object[]{this.schema});
        this.cachedObjectInspector = (StandardStructObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)rowTypeInfo);
        this.tsParser = new TimestampParser(HiveStringUtils.splitAndUnEscape((String)tbl.getProperty("timestamp.formats")));
        this.stats = new SerDeStats();
    }

    public Class<? extends Writable> getSerializedClass() {
        return ObjectWritable.class;
    }

    public Writable serialize(Object o, ObjectInspector objectInspector) throws SerDeException {
        throw new UnsupportedOperationException("This SerDe only supports deserialization");
    }

    public SerDeStats getSerDeStats() {
        return this.stats;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        ObjectWritable t = (ObjectWritable)writable;
        Record record = (Record)t.get();
        List<Object> result = this.deserialize(record, this.schema);
        this.stats.setRowCount(this.stats.getRowCount() + 1L);
        return result;
    }

    private List<Object> deserialize(Record record, StructTypeInfo schema) throws SerDeException {
        ArrayList<Object> result = new ArrayList<Object>(Collections.nCopies(schema.getAllStructFieldNames().size(), null));
        try {
            RecordSchema recordSchema = record.getSchema();
            for (RecordField field : recordSchema.getFields()) {
                this.populateRecord(result, record.getValue(field), field, schema);
            }
        }
        catch (SerDeException se) {
            this.log.error("Error [{}] parsing Record [{}].", new Object[]{se.toString(), record, se});
            throw se;
        }
        catch (Exception e) {
            this.log.error("Error [{}] parsing Record [{}].", new Object[]{e.toString(), record, e});
            throw new SerDeException((Throwable)e);
        }
        return result;
    }

    private Object extractCurrentField(Object fieldValue, String fieldName, DataType fieldDataType, TypeInfo fieldTypeInfo) throws SerDeException {
        Object val;
        if (fieldValue == null) {
            return null;
        }
        block0 : switch (fieldTypeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = PrimitiveObjectInspector.PrimitiveCategory.UNKNOWN;
                if (fieldTypeInfo instanceof PrimitiveTypeInfo) {
                    primitiveCategory = ((PrimitiveTypeInfo)fieldTypeInfo).getPrimitiveCategory();
                }
                switch (primitiveCategory) {
                    case BYTE: {
                        Integer bIntValue = DataTypeUtils.toInteger((Object)fieldValue, (String)fieldName);
                        val = bIntValue.byteValue();
                        break block0;
                    }
                    case SHORT: {
                        Integer sIntValue = DataTypeUtils.toInteger((Object)fieldValue, (String)fieldName);
                        val = sIntValue.shortValue();
                        break block0;
                    }
                    case INT: {
                        val = DataTypeUtils.toInteger((Object)fieldValue, (String)fieldName);
                        break block0;
                    }
                    case LONG: {
                        val = DataTypeUtils.toLong((Object)fieldValue, (String)fieldName);
                        break block0;
                    }
                    case BOOLEAN: {
                        val = DataTypeUtils.toBoolean((Object)fieldValue, (String)fieldName);
                        break block0;
                    }
                    case FLOAT: {
                        val = DataTypeUtils.toFloat((Object)fieldValue, (String)fieldName);
                        break block0;
                    }
                    case DOUBLE: {
                        val = DataTypeUtils.toDouble((Object)fieldValue, (String)fieldName);
                        break block0;
                    }
                    case STRING: 
                    case VARCHAR: 
                    case CHAR: {
                        val = DataTypeUtils.toString((Object)fieldValue, (String)fieldName);
                        break block0;
                    }
                    case BINARY: {
                        ArrayDataType arrayDataType = fieldValue instanceof String ? (ArrayDataType)RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.BYTE.getDataType()) : (ArrayDataType)fieldDataType;
                        Object[] array = DataTypeUtils.toArray((Object)fieldValue, (String)fieldName, (DataType)arrayDataType.getElementType());
                        val = AvroTypeUtil.convertByteArray((Object[])array).array();
                        break block0;
                    }
                    case DATE: {
                        Date d = DataTypeUtils.toDate((Object)fieldValue, () -> DataTypeUtils.getDateFormat((String)fieldDataType.getFormat()), (String)fieldName);
                        org.apache.hadoop.hive.common.type.Date hiveDate = new org.apache.hadoop.hive.common.type.Date();
                        hiveDate.setTimeInMillis(d.getTime());
                        val = hiveDate;
                        break block0;
                    }
                    case TIMESTAMP: {
                        Timestamp ts = DataTypeUtils.toTimestamp((Object)fieldValue, () -> DataTypeUtils.getDateFormat((String)fieldDataType.getFormat()), (String)fieldName);
                        org.apache.hadoop.hive.common.type.Timestamp hivetimestamp = new org.apache.hadoop.hive.common.type.Timestamp();
                        hivetimestamp.setTimeInMillis(ts.getTime(), ts.getNanos());
                        val = hivetimestamp;
                        break block0;
                    }
                    case DECIMAL: {
                        if (fieldValue instanceof BigDecimal) {
                            val = HiveDecimal.create((BigDecimal)((BigDecimal)fieldValue));
                            break block0;
                        }
                        if (fieldValue instanceof Number) {
                            val = HiveDecimal.create((double)((Number)fieldValue).doubleValue());
                            break block0;
                        }
                        val = HiveDecimal.create((double)DataTypeUtils.toDouble((Object)fieldValue, (String)fieldDataType.getFormat()));
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Field " + fieldName + " cannot be converted to type: " + primitiveCategory.name());
            }
            case LIST: {
                Object[] value = (Object[])fieldValue;
                ListTypeInfo listTypeInfo = (ListTypeInfo)fieldTypeInfo;
                TypeInfo nestedType = listTypeInfo.getListElementTypeInfo();
                ArrayList<Object> converted = new ArrayList<Object>(value.length);
                for (Object o : value) {
                    converted.add(this.extractCurrentField(o, fieldName, ((ArrayDataType)fieldDataType).getElementType(), nestedType));
                }
                val = converted;
                break;
            }
            case MAP: {
                Map valueMap = (Map)fieldValue;
                MapTypeInfo mapTypeInfo = (MapTypeInfo)fieldTypeInfo;
                HiveDecimal convertedMap = new HashMap(valueMap.size());
                for (Map.Entry entry : valueMap.entrySet()) {
                    convertedMap.put(this.extractCurrentField(entry.getKey(), fieldName + ".key", RecordFieldType.STRING.getDataType(), mapTypeInfo.getMapKeyTypeInfo()), this.extractCurrentField(entry.getValue(), fieldName + ".value", ((MapDataType)fieldDataType).getValueType(), mapTypeInfo.getMapValueTypeInfo()));
                }
                val = convertedMap;
                break;
            }
            case STRUCT: {
                Record nestedRecord = (Record)fieldValue;
                StructTypeInfo s = (StructTypeInfo)fieldTypeInfo;
                val = this.deserialize(nestedRecord, s);
                break;
            }
            default: {
                this.log.error("Unknown type found: " + fieldTypeInfo + "for field of type: " + fieldDataType.toString());
                return null;
            }
        }
        return val;
    }

    public ObjectInspector getObjectInspector() {
        return this.cachedObjectInspector;
    }

    private void populateRecord(List<Object> r, Object value, RecordField field, StructTypeInfo typeInfo) throws SerDeException {
        String fieldName = field.getFieldName();
        String normalizedFieldName = fieldName.toLowerCase();
        int fpos = typeInfo.getAllStructFieldNames().stream().map(s -> s == null ? null : s.toLowerCase()).collect(Collectors.toList()).indexOf(normalizedFieldName);
        if (fpos == -1) {
            Matcher m = INTERNAL_PATTERN.matcher(fieldName);
            fpos = m.matches() ? Integer.parseInt(m.group(1)) : -1;
            this.log.debug("NPE finding position for field [{}] in schema [{}], attempting to check if it is an internal column name like _col0", new Object[]{fieldName, typeInfo});
            if (fpos == -1) {
                this.log.debug("Field {} is not found in the target table, ignoring...", new Object[]{field.getFieldName()});
                return;
            }
            if (!fieldName.equalsIgnoreCase(HiveConf.getColumnInternalName((int)fpos))) {
                this.log.error("Hive internal column name {} and position encoding {} for the column name are at odds", new Object[]{fieldName, fpos});
                throw new SerDeException("Hive internal column name (" + fieldName + ") and position encoding (" + fpos + ") for the column name are at odds");
            }
        }
        Object currField = this.extractCurrentField(value, fieldName, field.getDataType(), typeInfo.getStructFieldTypeInfo(normalizedFieldName));
        r.set(fpos, currField);
    }
}

