/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hive;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.tree.CommonTree;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.dbcp.hive.HiveDBCPService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stream.io.StreamUtils;

public abstract class AbstractHiveQLProcessor
extends AbstractSessionFactoryProcessor {
    protected static final Pattern HIVEQL_TYPE_ATTRIBUTE_PATTERN = Pattern.compile("hiveql\\.args\\.(\\d+)\\.type");
    protected static final Pattern NUMBER_PATTERN = Pattern.compile("-?\\d+");
    static String ATTR_INPUT_TABLES = "query.input.tables";
    static String ATTR_OUTPUT_TABLES = "query.output.tables";
    public static final PropertyDescriptor HIVE_DBCP_SERVICE = new PropertyDescriptor.Builder().name("Hive Database Connection Pooling Service").description("The Hive Controller Service that is used to obtain connection(s) to the Hive database").required(true).identifiesControllerService(HiveDBCPService.class).build();
    public static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("hive-charset").displayName("Character Set").description("Specifies the character set of the record data.").required(true).defaultValue("UTF-8").addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).build();

    protected String getHiveQL(ProcessSession session, FlowFile flowFile, Charset charset) {
        final byte[] buffer = new byte[(int)flowFile.getSize()];
        session.read(flowFile, new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                StreamUtils.fillBuffer((InputStream)in, (byte[])buffer);
            }
        });
        return new String(buffer, charset);
    }

    protected int setParameters(int base, PreparedStatement stmt, int paramCount, Map<String, String> attributes) throws SQLException {
        TreeMap<Integer, ParameterHolder> parmMap = new TreeMap<Integer, ParameterHolder>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            int parameterIndex;
            String key = entry.getKey();
            Matcher matcher = HIVEQL_TYPE_ATTRIBUTE_PATTERN.matcher(key);
            if (!matcher.matches() || (parameterIndex = Integer.parseInt(matcher.group(1))) < base || parameterIndex >= base + paramCount) continue;
            boolean isNumeric = NUMBER_PATTERN.matcher(entry.getValue()).matches();
            if (!isNumeric) {
                throw new SQLDataException("Value of the " + key + " attribute is '" + entry.getValue() + "', which is not a valid JDBC numeral jdbcType");
            }
            String valueAttrName = "hiveql.args." + parameterIndex + ".value";
            ParameterHolder ph = new ParameterHolder();
            int realIndexLoc = parameterIndex - base + 1;
            ph.jdbcType = Integer.parseInt(entry.getValue());
            ph.value = attributes.get(valueAttrName);
            ph.attributeName = valueAttrName;
            parmMap.put(realIndexLoc, ph);
        }
        for (Map.Entry<String, String> entry : parmMap.entrySet()) {
            Integer index = (Integer)((Object)entry.getKey());
            ParameterHolder ph = (ParameterHolder)((Object)entry.getValue());
            try {
                this.setParameter(stmt, ph.attributeName, index, ph.value, ph.jdbcType);
            }
            catch (NumberFormatException nfe) {
                throw new SQLDataException("The value of the " + ph.attributeName + " is '" + ph.value + "', which cannot be converted into the necessary data jdbcType", nfe);
            }
        }
        return base + paramCount;
    }

    protected void setParameter(PreparedStatement stmt, String attrName, int parameterIndex, String parameterValue, int jdbcType) throws SQLException {
        if (parameterValue == null) {
            stmt.setNull(parameterIndex, jdbcType);
        } else {
            try {
                switch (jdbcType) {
                    case -7: 
                    case 16: {
                        stmt.setBoolean(parameterIndex, Boolean.parseBoolean(parameterValue));
                        break;
                    }
                    case -6: {
                        stmt.setByte(parameterIndex, Byte.parseByte(parameterValue));
                        break;
                    }
                    case 5: {
                        stmt.setShort(parameterIndex, Short.parseShort(parameterValue));
                        break;
                    }
                    case 4: {
                        stmt.setInt(parameterIndex, Integer.parseInt(parameterValue));
                        break;
                    }
                    case -5: {
                        stmt.setLong(parameterIndex, Long.parseLong(parameterValue));
                        break;
                    }
                    case 7: {
                        stmt.setFloat(parameterIndex, Float.parseFloat(parameterValue));
                        break;
                    }
                    case 6: 
                    case 8: {
                        stmt.setDouble(parameterIndex, Double.parseDouble(parameterValue));
                        break;
                    }
                    case 2: 
                    case 3: {
                        stmt.setBigDecimal(parameterIndex, new BigDecimal(parameterValue));
                        break;
                    }
                    case 91: {
                        stmt.setDate(parameterIndex, new Date(Long.parseLong(parameterValue)));
                        break;
                    }
                    case 92: {
                        stmt.setTime(parameterIndex, new Time(Long.parseLong(parameterValue)));
                        break;
                    }
                    case 93: {
                        stmt.setTimestamp(parameterIndex, new Timestamp(Long.parseLong(parameterValue)));
                        break;
                    }
                    case -16: 
                    case -1: 
                    case 1: 
                    case 12: {
                        stmt.setString(parameterIndex, parameterValue);
                        break;
                    }
                    default: {
                        stmt.setObject(parameterIndex, (Object)parameterValue, jdbcType);
                        break;
                    }
                }
            }
            catch (SQLException e) {
                this.getLogger().error("Error setting parameter {} to value from {} ({})", new Object[]{parameterIndex, attrName, parameterValue}, (Throwable)e);
                throw e;
            }
        }
    }

    protected Set<TableName> findTableNames(String query) {
        ASTNode node;
        try {
            node = new ParseDriver().parse(this.normalize(query));
        }
        catch (ParseException e) {
            this.getLogger().debug("Failed to parse query: {} due to {}", new Object[]{query, e}, (Throwable)e);
            return Collections.emptySet();
        }
        HashSet<TableName> tableNames = new HashSet<TableName>();
        this.findTableNames(node, tableNames);
        return tableNames;
    }

    private String normalize(String query) {
        return query.replace('?', 'x');
    }

    private void findTableNames(Object obj, Set<TableName> tableNames) {
        if (!(obj instanceof CommonTree)) {
            return;
        }
        CommonTree tree = (CommonTree)obj;
        int childCount = tree.getChildCount();
        if ("TOK_TABNAME".equals(tree.getText())) {
            TableName tableName;
            boolean isInput = "TOK_TABREF".equals(tree.getParent().getText());
            switch (childCount) {
                case 1: {
                    tableName = new TableName(null, tree.getChild(0).getText(), isInput);
                    break;
                }
                case 2: {
                    tableName = new TableName(tree.getChild(0).getText(), tree.getChild(1).getText(), isInput);
                    break;
                }
                default: {
                    throw new IllegalStateException("TOK_TABNAME does not have expected children, childCount=" + childCount);
                }
            }
            tableNames.add(tableName);
            return;
        }
        for (int i = 0; i < childCount; ++i) {
            this.findTableNames(tree.getChild(i), tableNames);
        }
    }

    protected Map<String, String> toQueryTableAttributes(Set<TableName> tableNames) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (TableName tableName : tableNames) {
            String attributeName;
            String string = attributeName = tableName.isInput() ? ATTR_INPUT_TABLES : ATTR_OUTPUT_TABLES;
            if (attributes.containsKey(attributeName)) {
                attributes.put(attributeName, (String)attributes.get(attributeName) + "," + tableName);
                continue;
            }
            attributes.put(attributeName, tableName.toString());
        }
        return attributes;
    }

    protected static class TableName {
        private final String database;
        private final String table;
        private final boolean input;

        TableName(String database, String table, boolean input) {
            this.database = database;
            this.table = table;
            this.input = input;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getTable() {
            return this.table;
        }

        public boolean isInput() {
            return this.input;
        }

        public String toString() {
            return this.database == null || this.database.isEmpty() ? this.table : this.database + "." + this.table;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableName tableName = (TableName)o;
            if (this.input != tableName.input) {
                return false;
            }
            if (this.database != null ? !this.database.equals(tableName.database) : tableName.database != null) {
                return false;
            }
            return this.table.equals(tableName.table);
        }

        public int hashCode() {
            int result = this.database != null ? this.database.hashCode() : 0;
            result = 31 * result + this.table.hashCode();
            result = 31 * result + (this.input ? 1 : 0);
            return result;
        }
    }

    private class ParameterHolder {
        String attributeName;
        int jdbcType;
        String value;

        private ParameterHolder() {
        }
    }
}

