/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop.util;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.processor.exception.ProcessException;

public class FileStatusIterable
implements Iterable<FileStatus> {
    private final Path path;
    private final boolean recursive;
    private final FileSystem fileSystem;
    private final UserGroupInformation userGroupInformation;
    private long totalFileCount;

    public FileStatusIterable(Path path, boolean recursive, FileSystem fileSystem, UserGroupInformation userGroupInformation) {
        this.path = path;
        this.recursive = recursive;
        this.fileSystem = fileSystem;
        this.userGroupInformation = userGroupInformation;
    }

    @Override
    public Iterator<FileStatus> iterator() {
        return new FileStatusIterator();
    }

    public long getTotalFileCount() {
        return this.totalFileCount;
    }

    class FileStatusIterator
    implements Iterator<FileStatus> {
        private static final String IO_ERROR_MESSAGE = "IO error occurred while iterating Hadoop File System";
        private static final String THREAD_INTERRUPT_ERROR_MESSAGE = "Thread was interrupted while iterating Hadoop File System";
        private final Deque<Path> dirPaths = new ArrayDeque<Path>();
        private FileStatus nextFileStatus;
        private RemoteIterator<FileStatus> remoteIterator;

        public FileStatusIterator() {
            this.remoteIterator = this.getRemoteIterator(FileStatusIterable.this.path);
        }

        @Override
        public boolean hasNext() {
            if (this.nextFileStatus != null) {
                return true;
            }
            try {
                while (this.remoteIterator.hasNext() || !this.dirPaths.isEmpty()) {
                    if (this.remoteIterator.hasNext()) {
                        FileStatus fs = (FileStatus)this.remoteIterator.next();
                        if (fs.isDirectory()) {
                            if (!FileStatusIterable.this.recursive) continue;
                            this.dirPaths.push(fs.getPath());
                            continue;
                        }
                        this.nextFileStatus = fs;
                        return true;
                    }
                    this.remoteIterator = this.getRemoteIterator(this.dirPaths.pop());
                }
                return false;
            }
            catch (IOException e) {
                throw new ProcessException(IO_ERROR_MESSAGE, (Throwable)e);
            }
        }

        @Override
        public FileStatus next() {
            if (this.nextFileStatus == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++FileStatusIterable.this.totalFileCount;
            FileStatus nextFileStatus = this.nextFileStatus;
            this.nextFileStatus = null;
            return nextFileStatus;
        }

        private RemoteIterator<FileStatus> getRemoteIterator(Path currentPath) {
            try {
                return (RemoteIterator)FileStatusIterable.this.userGroupInformation.doAs(() -> FileStatusIterable.this.fileSystem.listStatusIterator(currentPath));
            }
            catch (IOException e) {
                throw new ProcessException(IO_ERROR_MESSAGE, (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ProcessException(THREAD_INTERRUPT_ERROR_MESSAGE, (Throwable)e);
            }
        }
    }
}

