/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop.util;

import java.util.stream.Stream;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.processors.hadoop.ListHDFS;

public enum FilterMode implements DescribedValue
{
    FILTER_DIRECTORIES_AND_FILES("filter-mode-directories-and-files", "Directories and Files", "Filtering will be applied to the names of directories and files.  If " + ListHDFS.RECURSE_SUBDIRS.getDisplayName() + " is set to true, only subdirectories with a matching name will be searched for files that match the regular expression defined in " + ListHDFS.FILE_FILTER.getDisplayName() + "."),
    FILTER_MODE_FILES_ONLY("filter-mode-files-only", "Files Only", "Filtering will only be applied to the names of files.  If " + ListHDFS.RECURSE_SUBDIRS.getDisplayName() + " is set to true, the entire subdirectory tree will be searched for files that match the regular expression defined in " + ListHDFS.FILE_FILTER.getDisplayName() + "."),
    FILTER_MODE_FULL_PATH("filter-mode-full-path", "Full Path", "Filtering will be applied by evaluating the regular expression defined in " + ListHDFS.FILE_FILTER.getDisplayName() + " against the full path of files with and without the scheme and authority.  If " + ListHDFS.RECURSE_SUBDIRS.getDisplayName() + " is set to true, the entire subdirectory tree will be searched for files in which the full path of the file matches the regular expression defined in " + ListHDFS.FILE_FILTER.getDisplayName() + ".  See 'Additional Details' for more information.");

    private final String value;
    private final String displayName;
    private final String description;

    private FilterMode(String value, String displayName, String description) {
        this.value = value;
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public static FilterMode forName(String filterMode) {
        return Stream.of(FilterMode.values()).filter(fm -> fm.getValue().equalsIgnoreCase(filterMode)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid filter mode: " + filterMode));
    }
}

