/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.hadoop.util.ByteFilteringOutputStream;
import org.apache.nifi.processors.hadoop.util.InputStreamWritable;
import org.apache.nifi.processors.hadoop.util.SequenceFileWriter;
import org.apache.nifi.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceFileWriterImpl
implements SequenceFileWriter {
    protected static Logger logger = LoggerFactory.getLogger(SequenceFileWriterImpl.class);

    @Override
    public FlowFile writeSequenceFile(final FlowFile flowFile, ProcessSession session, final Configuration configuration, final SequenceFile.CompressionType compressionType, final CompressionCodec compressionCodec) {
        byte[] replaceWith;
        byte[] toReplace;
        if (flowFile.getSize() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot write " + flowFile + "to Sequence File because its size is greater than the largest possible Integer");
        }
        String sequenceFilename = flowFile.getAttribute(CoreAttributes.FILENAME.key()) + ".sf";
        try {
            toReplace = InputStreamWritable.class.getCanonicalName().getBytes("UTF-8");
            replaceWith = BytesWritable.class.getCanonicalName().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 is not a supported Character Format");
        }
        final StopWatch watch = new StopWatch(true);
        FlowFile sfFlowFile = session.write(flowFile, new StreamCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(InputStream in, OutputStream out) throws IOException {
                ByteFilteringOutputStream bwos = new ByteFilteringOutputStream(out);
                bwos.addFilter(toReplace, replaceWith, 1);
                bwos.addFilter((byte)InputStreamWritable.class.getCanonicalName().length(), (byte)BytesWritable.class.getCanonicalName().length(), 1);
                try (FSDataOutputStream fsDataOutputStream = new FSDataOutputStream((OutputStream)bwos, new FileSystem.Statistics(""));
                     SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)configuration, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.stream((FSDataOutputStream)fsDataOutputStream), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(InputStreamWritable.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)compressionType, (CompressionCodec)compressionCodec)});){
                    SequenceFileWriterImpl.this.processInputStream(in, flowFile, writer);
                }
                finally {
                    watch.stop();
                }
            }
        });
        logger.debug("Wrote Sequence File {} ({}).", (Object)sequenceFilename, (Object)watch.calculateDataRate(flowFile.getSize()));
        return sfFlowFile;
    }

    protected void processInputStream(InputStream stream, FlowFile flowFile, SequenceFile.Writer writer) throws IOException {
        int fileSize = (int)flowFile.getSize();
        InputStreamWritable inStreamWritable = new InputStreamWritable(new BufferedInputStream(stream), fileSize);
        String key = flowFile.getAttribute(CoreAttributes.FILENAME.key());
        writer.append((Writable)new Text(key), (Writable)inStreamWritable);
    }
}

