/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop.util;

import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;

public class OutputStreamWritable
implements Writable {
    private static final int BUFFER_SIZE = 16384;
    private final DataOutputStream dos;
    private final boolean writeLength;

    public OutputStreamWritable(OutputStream out, boolean writeLength) {
        this.dos = new DataOutputStream(new BufferedOutputStream(out, 16384));
        this.writeLength = writeLength;
    }

    public void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("OutputStreamWritable does not implement #write");
    }

    public void readFields(DataInput in) throws IOException {
        if (in instanceof DataInputBuffer) {
            byte[] bytes = ((DataInputBuffer)in).getData();
            int pos = ((DataInputBuffer)in).getPosition();
            int length = ((DataInputBuffer)in).getLength();
            int bytesRemaining = length - pos;
            if (this.writeLength) {
                this.dos.write(bytes, pos, bytesRemaining);
            } else {
                this.dos.write(bytes, pos + 4, bytesRemaining - 4);
            }
            in.skipBytes(bytesRemaining);
        } else {
            int length = in.readInt();
            if (this.writeLength) {
                this.dos.writeInt(length);
            }
            int numRead = 0;
            int toRead = Math.min(16384, length);
            byte[] buffer = new byte[16384];
            while (toRead > 0) {
                in.readFully(buffer, 0, toRead);
                this.dos.write(buffer, 0, toRead);
                toRead = Math.min(16384, length - (numRead += toRead));
            }
        }
        this.dos.flush();
    }
}

