/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.nifi.hbase.io.RowSerializer;
import org.apache.nifi.hbase.scan.ResultCell;

public class JsonRowSerializer
implements RowSerializer {
    private final Charset charset;

    public JsonRowSerializer(Charset charset) {
        this.charset = charset;
    }

    @Override
    public String serialize(byte[] rowKey, ResultCell[] cells) {
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("{");
        String row = new String(rowKey, this.charset);
        jsonBuilder.append("\"row\":").append("\"").append(StringEscapeUtils.escapeJson((String)row)).append("\"");
        jsonBuilder.append(", \"cells\": {");
        int i = 0;
        for (ResultCell cell : cells) {
            String cellFamily = new String(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), this.charset);
            String cellQualifier = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), this.charset);
            if (i > 0) {
                jsonBuilder.append(", ");
            }
            jsonBuilder.append("\"").append(StringEscapeUtils.escapeJson((String)cellFamily)).append(":").append(StringEscapeUtils.escapeJson((String)cellQualifier)).append("\":\"").append(StringEscapeUtils.escapeJson((String)new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength(), this.charset))).append("\"");
            ++i;
        }
        jsonBuilder.append("}}");
        return jsonBuilder.toString();
    }

    @Override
    public void serialize(byte[] rowKey, ResultCell[] cells, OutputStream out) throws IOException {
        String json = this.serialize(rowKey, cells);
        out.write(json.getBytes(this.charset));
    }
}

