/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.hbase.HBaseClientService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public abstract class AbstractDeleteHBase
extends AbstractProcessor {
    protected static final PropertyDescriptor HBASE_CLIENT_SERVICE = new PropertyDescriptor.Builder().name("HBase Client Service").description("Specifies the Controller Service to use for accessing HBase.").required(true).identifiesControllerService(HBaseClientService.class).build();
    protected static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("Table Name").description("The name of the HBase Table.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    protected static final PropertyDescriptor ROW_ID = new PropertyDescriptor.Builder().name("Row Identifier").description("Specifies the Row ID to use when deleting data into HBase").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile is routed to this relationship after it has been successfully stored in HBase").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile is routed to this relationship if it cannot be sent to HBase").build();
    protected HBaseClientService clientService;

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.clientService = (HBaseClientService)context.getProperty(HBASE_CLIENT_SERVICE).asControllerService(HBaseClientService.class);
    }

    public Set<Relationship> getRelationships() {
        HashSet<Relationship> set = new HashSet<Relationship>();
        set.add(REL_SUCCESS);
        set.add(REL_FAILURE);
        return set;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(HBASE_CLIENT_SERVICE);
        properties.add(TABLE_NAME);
        properties.add(ROW_ID);
        return properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        try {
            this.doDelete(context, session);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to perform delete", (Throwable)e);
        }
    }

    protected abstract void doDelete(ProcessContext var1, ProcessSession var2) throws Exception;
}

