/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hazelcast.services.cache;

import com.hazelcast.map.IMap;
import com.hazelcast.map.ReachedMaxSizeException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.nifi.hazelcast.services.cache.HazelcastCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMapBasedHazelcastCache
implements HazelcastCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(IMapBasedHazelcastCache.class);
    private final long ttlInMillis;
    private final IMap<String, byte[]> storage;

    public IMapBasedHazelcastCache(IMap<String, byte[]> storage, long ttlInMillis) {
        this.ttlInMillis = ttlInMillis;
        this.storage = storage;
    }

    public String name() {
        return this.storage.getName();
    }

    public byte[] get(String key) {
        return (byte[])this.storage.get((Object)key);
    }

    public byte[] putIfAbsent(String key, byte[] value) {
        return (byte[])this.storage.putIfAbsent((Object)key, (Object)value, this.ttlInMillis, TimeUnit.MILLISECONDS);
    }

    public boolean put(String key, byte[] value) {
        try {
            this.storage.put((Object)key, (Object)value, this.ttlInMillis, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (ReachedMaxSizeException e) {
            LOGGER.error("Cache {} reached the maximum allowed size!", (Object)this.storage.getName());
            return false;
        }
    }

    public boolean contains(String key) {
        return this.storage.containsKey((Object)key);
    }

    public boolean remove(String key) {
        return this.storage.remove((Object)key) != null;
    }

    public int removeAll(Predicate<String> keyMatcher) {
        Set keys = this.storage.keySet();
        int result = 0;
        for (String key : keys) {
            if (!keyMatcher.test(key)) continue;
            this.storage.delete((Object)key);
            ++result;
        }
        return result;
    }

    public HazelcastCache.HazelcastCacheEntryLock acquireLock(String key) {
        if (key == null) {
            throw new IllegalArgumentException("The key of acquired lock cannot be null!");
        }
        IMapAdapterEntryLock lock = new IMapAdapterEntryLock(key);
        lock.lock();
        return lock;
    }

    private final class IMapAdapterEntryLock
    implements HazelcastCache.HazelcastCacheEntryLock {
        private final String key;

        private IMapAdapterEntryLock(String key) {
            this.key = key;
        }

        void lock() {
            IMapBasedHazelcastCache.this.storage.lock((Object)this.key);
        }

        public void close() {
            IMapBasedHazelcastCache.this.storage.unlock((Object)this.key);
        }
    }
}

