/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.nifi.org.h2.engine.CastDataProvider;
import org.apache.nifi.org.h2.message.DbException;
import org.apache.nifi.org.h2.util.Bits;
import org.apache.nifi.org.h2.util.StringUtils;
import org.apache.nifi.org.h2.util.Utils;
import org.apache.nifi.org.h2.util.geometry.EWKBUtils;
import org.apache.nifi.org.h2.util.geometry.EWKTUtils;
import org.apache.nifi.org.h2.util.geometry.GeometryUtils;
import org.apache.nifi.org.h2.util.geometry.JTSUtils;
import org.apache.nifi.org.h2.value.CompareMode;
import org.apache.nifi.org.h2.value.DataType;
import org.apache.nifi.org.h2.value.TypeInfo;
import org.apache.nifi.org.h2.value.Value;
import org.apache.nifi.org.h2.value.ValueNull;
import org.locationtech.jts.geom.Geometry;

public class ValueGeometry
extends Value {
    private static final double[] UNKNOWN_ENVELOPE = new double[0];
    private final byte[] bytes;
    private final int hashCode;
    private final int typeAndDimensionSystem;
    private final int srid;
    private double[] envelope;
    private Object geometry;

    private ValueGeometry(byte[] byArray, double[] dArray) {
        if (byArray.length < 9 || byArray[0] != 0) {
            throw DbException.get(22018, StringUtils.convertBytesToHex(byArray));
        }
        this.bytes = byArray;
        this.envelope = dArray;
        int n = Bits.readInt(byArray, 1);
        this.srid = (n & 0x20000000) != 0 ? Bits.readInt(byArray, 5) : 0;
        this.typeAndDimensionSystem = (n & 0xFFFF) % 1000 + EWKBUtils.type2dimensionSystem(n) * 1000;
        this.hashCode = Arrays.hashCode(byArray);
    }

    public static ValueGeometry getFromGeometry(Object object) {
        try {
            GeometryUtils.EnvelopeAndDimensionSystemTarget envelopeAndDimensionSystemTarget = new GeometryUtils.EnvelopeAndDimensionSystemTarget();
            Geometry geometry = (Geometry)object;
            JTSUtils.parseGeometry(geometry, envelopeAndDimensionSystemTarget);
            return (ValueGeometry)Value.cache(new ValueGeometry(JTSUtils.geometry2ewkb(geometry, envelopeAndDimensionSystemTarget.getDimensionSystem()), envelopeAndDimensionSystemTarget.getEnvelope()));
        }
        catch (RuntimeException runtimeException) {
            throw DbException.get(22018, String.valueOf(object));
        }
    }

    public static ValueGeometry get(String string) {
        try {
            GeometryUtils.EnvelopeAndDimensionSystemTarget envelopeAndDimensionSystemTarget = new GeometryUtils.EnvelopeAndDimensionSystemTarget();
            EWKTUtils.parseEWKT(string, envelopeAndDimensionSystemTarget);
            return (ValueGeometry)Value.cache(new ValueGeometry(EWKTUtils.ewkt2ewkb(string, envelopeAndDimensionSystemTarget.getDimensionSystem()), envelopeAndDimensionSystemTarget.getEnvelope()));
        }
        catch (RuntimeException runtimeException) {
            throw DbException.get(22018, string);
        }
    }

    public static ValueGeometry get(String string, int n) {
        return ValueGeometry.get(n == 0 ? string : "SRID=" + n + ';' + string);
    }

    public static ValueGeometry get(byte[] byArray) {
        return (ValueGeometry)Value.cache(new ValueGeometry(byArray, UNKNOWN_ENVELOPE));
    }

    public static ValueGeometry getFromEWKB(byte[] byArray) {
        try {
            GeometryUtils.EnvelopeAndDimensionSystemTarget envelopeAndDimensionSystemTarget = new GeometryUtils.EnvelopeAndDimensionSystemTarget();
            EWKBUtils.parseEWKB(byArray, envelopeAndDimensionSystemTarget);
            return (ValueGeometry)Value.cache(new ValueGeometry(EWKBUtils.ewkb2ewkb(byArray, envelopeAndDimensionSystemTarget.getDimensionSystem()), envelopeAndDimensionSystemTarget.getEnvelope()));
        }
        catch (RuntimeException runtimeException) {
            throw DbException.get(22018, StringUtils.convertBytesToHex(byArray));
        }
    }

    public static Value fromEnvelope(double[] dArray) {
        return dArray != null ? Value.cache(new ValueGeometry(EWKBUtils.envelope2wkb(dArray), dArray)) : ValueNull.INSTANCE;
    }

    public Geometry getGeometry() {
        if (this.geometry == null) {
            try {
                this.geometry = JTSUtils.ewkb2geometry(this.bytes, this.getDimensionSystem());
            }
            catch (RuntimeException runtimeException) {
                throw DbException.convert(runtimeException);
            }
        }
        return ((Geometry)this.geometry).copy();
    }

    public int getTypeAndDimensionSystem() {
        return this.typeAndDimensionSystem;
    }

    public int getGeometryType() {
        return this.typeAndDimensionSystem % 1000;
    }

    public int getDimensionSystem() {
        return this.typeAndDimensionSystem / 1000;
    }

    public int getSRID() {
        return this.srid;
    }

    public double[] getEnvelopeNoCopy() {
        if (this.envelope == UNKNOWN_ENVELOPE) {
            GeometryUtils.EnvelopeTarget envelopeTarget = new GeometryUtils.EnvelopeTarget();
            EWKBUtils.parseEWKB(this.bytes, envelopeTarget);
            this.envelope = envelopeTarget.getEnvelope();
        }
        return this.envelope;
    }

    public boolean intersectsBoundingBox(ValueGeometry valueGeometry) {
        return GeometryUtils.intersects(this.getEnvelopeNoCopy(), valueGeometry.getEnvelopeNoCopy());
    }

    public Value getEnvelopeUnion(ValueGeometry valueGeometry) {
        return ValueGeometry.fromEnvelope(GeometryUtils.union(this.getEnvelopeNoCopy(), valueGeometry.getEnvelopeNoCopy()));
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_GEOMETRY;
    }

    @Override
    public int getValueType() {
        return 22;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append("X'");
        return StringUtils.convertBytesToHex(stringBuilder, this.getBytesNoCopy()).append("'::Geometry");
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return Bits.compareNotNullUnsigned(this.bytes, ((ValueGeometry)value).bytes);
    }

    @Override
    public String getString() {
        return this.getEWKT();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Object getObject() {
        if (DataType.GEOMETRY_CLASS != null) {
            return this.getGeometry();
        }
        return this.getEWKT();
    }

    @Override
    public byte[] getBytes() {
        return Utils.cloneByteArray(this.bytes);
    }

    @Override
    public byte[] getBytesNoCopy() {
        return this.bytes;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBytes(n, this.bytes);
    }

    @Override
    public int getMemory() {
        return this.bytes.length * 20 + 24;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueGeometry && Arrays.equals(this.bytes, ((ValueGeometry)object).bytes);
    }

    public String getEWKT() {
        return EWKTUtils.ewkb2ewkt(this.bytes, this.getDimensionSystem());
    }

    public byte[] getEWKB() {
        return this.bytes;
    }
}

