/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.index;

import v14.h2.command.dml.AllColumnsForPlan;
import v14.h2.engine.Session;
import v14.h2.index.Cursor;
import v14.h2.index.RangeCursor;
import v14.h2.index.VirtualTableIndex;
import v14.h2.message.DbException;
import v14.h2.result.SearchRow;
import v14.h2.result.SortOrder;
import v14.h2.table.IndexColumn;
import v14.h2.table.RangeTable;
import v14.h2.table.TableFilter;

public class RangeIndex
extends VirtualTableIndex {
    private final RangeTable rangeTable;

    public RangeIndex(RangeTable rangeTable, IndexColumn[] indexColumnArray) {
        super(rangeTable, "RANGE_INDEX", indexColumnArray);
        this.rangeTable = rangeTable;
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        long l;
        long l2 = this.rangeTable.getMin(session);
        long l3 = this.rangeTable.getMax(session);
        long l4 = this.rangeTable.getStep(session);
        if (searchRow != null) {
            try {
                l = searchRow.getValue(0).getLong();
                if (l4 > 0L) {
                    if (l > l2) {
                        l2 += (l - l2 + l4 - 1L) / l4 * l4;
                    }
                } else if (l > l3) {
                    l3 = l;
                }
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        if (searchRow2 != null) {
            try {
                l = searchRow2.getValue(0).getLong();
                if (l4 > 0L) {
                    if (l < l3) {
                        l3 = l;
                    }
                } else if (l < l2) {
                    l2 -= (l2 - l - l4 - 1L) / l4 * l4;
                }
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        return new RangeCursor(session, l2, l3, l4);
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        return 1.0;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        long l = bl ? this.rangeTable.getMin(session) : this.rangeTable.getMax(session);
        return new RangeCursor(session, l, l);
    }

    @Override
    public String getPlanSQL() {
        return "range index";
    }
}

