/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.h2.database.migration;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.nifi.org.h2.jdbcx.JdbcDataSource;

public class H2DatabaseMigrator {
    public static final String BACKUP_FILE_POSTFIX = ".migration_backup";

    public static void exportAndBackup(String dbUrl, String dbPath, String user, String pass) {
        Statement s;
        Connection conn;
        JdbcDataSource migrationDataSource = new JdbcDataSource();
        migrationDataSource.setURL(dbUrl);
        migrationDataSource.setUser(user);
        migrationDataSource.setPassword(pass);
        File dbPathFile = Paths.get(dbPath, new String[0]).toFile();
        String exportFile = Paths.get(dbPathFile.getParent(), "export_" + dbPathFile.getName() + ".sql").toString();
        try {
            conn = migrationDataSource.getConnection();
            s = conn.createStatement();
        }
        catch (SQLException sqle) {
            String message = String.format("H2 1.4 connection failed URL [%s] Path [%s] SQL State [%s]", dbUrl, dbPath, sqle.getSQLState());
            throw new RuntimeException(message, sqle);
        }
        try {
            s.execute("SCRIPT TO '" + exportFile + "'");
        }
        catch (SQLException sqle) {
            try {
                s.close();
            }
            catch (SQLException message) {
                // empty catch block
            }
            String message = String.format("H2 1.4 export failed URL [%s] Path [%s] SQL State [%s]", dbUrl, dbPath, sqle.getSQLState());
            throw new RuntimeException(message, sqle);
        }
        H2DatabaseMigrator.closeQuietly(s);
        H2DatabaseMigrator.closeQuietly(conn);
        if (!Files.exists(Paths.get(exportFile, new String[0]), new LinkOption[0])) {
            throw new RuntimeException(String.format("H2 1.4 export failed URL [%s] Path [%s] Export File not found [%s]", dbUrl, dbPath, exportFile));
        }
        File dbDir = new File(dbPath).getParentFile();
        File[] dbFiles = dbDir.listFiles((dir, name) -> !name.endsWith(".sql") && name.startsWith(dbPathFile.getName()));
        if (dbFiles == null || dbFiles.length == 0) {
            throw new RuntimeException(String.format("H2 1.4 backup failed URL [%s] Path [%s] no database files found", dbUrl, dbPath));
        }
        for (File dbFile : dbFiles) {
            File dbBackupFile = new File(dbFile.getAbsolutePath() + BACKUP_FILE_POSTFIX);
            if (dbFile.renameTo(dbBackupFile)) continue;
            throw new RuntimeException(String.format("H2 1.4 backup failed URL [%s] Path [%s] rename failed [%s]", dbUrl, dbPath, dbFile));
        }
    }

    private static void closeQuietly(Statement statement) {
        try {
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void closeQuietly(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

