/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.storage;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.BaseServiceException;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.AbstractGCPProcessor;
import org.apache.nifi.processors.gcp.ProxyAwareTransportFactory;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;

public abstract class AbstractGCSProcessor
extends AbstractGCPProcessor<Storage, StorageOptions>
implements VerifiableProcessor {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles are routed to this relationship after a successful Google Cloud Storage operation.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to this relationship if the Google Cloud Storage operation fails.").build();
    public static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    public static final PropertyDescriptor STORAGE_API_URL = new PropertyDescriptor.Builder().name("storage-api-url").displayName("Storage API URL").description("Overrides the default storage URL. Configuring an alternative Storage API URL also overrides the HTTP Host header on requests as described in the Google documentation for Private Service Connections.").addValidator(StandardValidators.URL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).build();

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        propertyDescriptors.add(STORAGE_API_URL);
        return Collections.unmodifiableList(propertyDescriptors);
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>(this.verifyCloudService(context, verificationLogger, attributes));
        Storage storage = (Storage)this.getCloudService(context);
        if (storage != null) {
            try {
                String bucket = this.getBucketName(context, attributes);
                List<String> requiredPermissions = this.getRequiredPermissions();
                if (storage.testIamPermissions(bucket, requiredPermissions, new Storage.BucketSourceOption[0]).size() >= requiredPermissions.size()) {
                    results.add(new ConfigVerificationResult.Builder().verificationStepName("Test IAM Permissions").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation(String.format("Verified Bucket [%s] exists and the configured user has the correct permissions.", bucket)).build());
                } else {
                    results.add(new ConfigVerificationResult.Builder().verificationStepName("Test IAM Permissions").outcome(ConfigVerificationResult.Outcome.FAILED).explanation(String.format("The configured user does not have the correct permissions on Bucket [%s].", bucket)).build());
                }
            }
            catch (BaseServiceException e) {
                verificationLogger.error("The configured user appears to have the correct permissions, but the following error was encountered", (Throwable)e);
                results.add(new ConfigVerificationResult.Builder().verificationStepName("Test IAM Permissions").outcome(ConfigVerificationResult.Outcome.FAILED).explanation(String.format("The configured user appears to have the correct permissions, but the following error was encountered: " + e.getMessage(), new Object[0])).build());
            }
        }
        return results;
    }

    protected final Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        Collection results = super.customValidate(validationContext);
        ProxyConfiguration.validateProxySpec((ValidationContext)validationContext, (Collection)results, (ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS);
        this.customValidate(validationContext, results);
        return results;
    }

    protected void customValidate(ValidationContext validationContext, Collection<ValidationResult> results) {
    }

    protected abstract List<String> getRequiredPermissions();

    protected String getBucketName(ProcessContext context, Map<String, String> attributes) {
        return context.getProperty("gcs-bucket").evaluateAttributeExpressions(attributes).getValue();
    }

    @Override
    protected StorageOptions getServiceOptions(ProcessContext context, GoogleCredentials credentials) {
        String projectId = context.getProperty(PROJECT_ID).evaluateAttributeExpressions().getValue();
        String storageApiUrl = context.getProperty(STORAGE_API_URL).evaluateAttributeExpressions().getValue();
        Integer retryCount = context.getProperty(RETRY_COUNT).asInteger();
        StorageOptions.Builder storageOptionsBuilder = (StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)credentials)).setRetrySettings(RetrySettings.newBuilder().setMaxAttempts(retryCount.intValue()).build());
        if (projectId != null && !projectId.isEmpty()) {
            storageOptionsBuilder.setProjectId(projectId);
        }
        if (storageApiUrl != null && !storageApiUrl.isEmpty()) {
            storageOptionsBuilder.setHost(storageApiUrl);
            storageOptionsBuilder.setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((Map)ImmutableMap.of((Object)"Host", (Object)"www.googleapis.com")));
        }
        return ((StorageOptions.Builder)storageOptionsBuilder.setTransportOptions(this.getTransportOptions(context))).build();
    }

    protected String getTransitUri(String storageApiUrl, String bucketName, String key) {
        URI apiUri = URI.create(storageApiUrl);
        return String.format("%s://%s.%s/%s", apiUri.getScheme(), bucketName, apiUri.getHost(), key);
    }
}

